/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.command;

import java.lang.reflect.Method;
import java.util.Arrays;
import me.nullaqua.api.command.CommandHelper;
import me.nullaqua.api.reflect.ConstructorAccessor;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class CommandManager {
    private static final ConstructorAccessor<PluginCommand> constructor = ConstructorAccessor.getDeclaredConstructor(PluginCommand.class, String.class, Plugin.class);
    private static final SimpleCommandMap commandMap;

    public static void useCommand(final CommandSender sender, final String cmd, Plugin plugin) {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getServer().dispatchCommand(sender, cmd);
            }
        }.runTask(plugin);
    }

    public static boolean registerPluginCommand(String command, Plugin plugin, CommandExecutor executor, String ... alias) {
        PluginCommand pluginCommand = CommandManager.newPluginCommand(command, plugin);
        assert (pluginCommand != null);
        pluginCommand.setExecutor(executor);
        pluginCommand.setAliases(Arrays.asList(alias));
        return CommandManager.registerPluginCommand(pluginCommand);
    }

    public static boolean registerPluginCommand(String command, Plugin plugin, CommandExecutor executor) {
        PluginCommand pluginCommand = CommandManager.newPluginCommand(command, plugin);
        assert (pluginCommand != null);
        pluginCommand.setExecutor(executor);
        return CommandManager.registerPluginCommand(pluginCommand);
    }

    public static PluginCommand newPluginCommand(String name, Plugin plugin) {
        try {
            return constructor.invoke(name, plugin);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean registerPluginCommand(PluginCommand command) {
        JavaPlugin.getProvidingPlugin(CommandManager.class).getLogger().info("Register command " + command.getPlugin().getName() + ":" + command.getName());
        return CommandManager.registerCommand(command.getPlugin().getName(), (Command)command);
    }

    public static boolean registerCommand(String fallbackPrefix, Command command) {
        command.unregister((CommandMap)CommandManager.getCommandMap());
        return commandMap.register(fallbackPrefix, command);
    }

    public static SimpleCommandMap getCommandMap() {
        return commandMap;
    }

    public static boolean registerPluginCommand(JavaPlugin plugin, Class<?> clazz) {
        return CommandManager.registerPluginCommand(CommandManager.createCommand(plugin, clazz));
    }

    public static PluginCommand createCommand(JavaPlugin plugin, Class<?> clazz) {
        return CommandHelper.fastCreateCommand(plugin, clazz);
    }

    public static boolean registerPluginCommand(JavaPlugin plugin, Object object) {
        return CommandManager.registerPluginCommand(CommandManager.createCommand(plugin, object));
    }

    public static PluginCommand createCommand(JavaPlugin plugin, Object object) {
        return CommandHelper.fastCreateCommand(plugin, object);
    }

    static {
        Server server = Bukkit.getServer();
        SimpleCommandMap cmdMap = null;
        try {
            Method method = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            cmdMap = (SimpleCommandMap)method.invoke((Object)server, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        commandMap = cmdMap;
    }
}

