/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.nullaqua.api.config.AutoSerialize;
import me.nullaqua.api.config.SerializeAs;
import me.nullaqua.api.config.SpecialSerialize;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.java.JavaPlugin;

public final class AutoSerializeImpl
implements AutoSerialize {
    public static final String nameOfAutoSerialize;
    private static final HashMap<String, Class<? extends AutoSerialize>> classNames;

    private AutoSerializeImpl() {
    }

    public static void register() {
        ConfigurationSerialization.unregisterClass(AutoSerializeImpl.class);
        ConfigurationSerialization.registerClass(AutoSerializeImpl.class, (String)nameOfAutoSerialize);
    }

    public static AutoSerialize deserialize(Map<String, Object> map) {
        Field[] fields;
        AutoSerialize object;
        String clazzName = (String)map.get("class");
        Class<? extends AutoSerialize> clazz = classNames.get(clazzName);
        if (clazz == null) {
            Bukkit.getLogger().warning(ChatColor.RED + "\u53cd\u5e8f\u5217\u5316\u5931\u8d25,\u672a\u627e\u5230\u7c7b: \"" + clazzName + "\"");
            return null;
        }
        try {
            object = clazz.newInstance();
        }
        catch (Throwable e) {
            System.out.println(ChatColor.RED + "\u65b0\u5efa\u5bf9\u8c61\u5931\u8d25");
            throw new RuntimeException(e);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.isAnnotationPresent(SpecialSerialize.class)) {
                    SpecialSerialize specialSerialize = field.getAnnotation(SpecialSerialize.class);
                    if (specialSerialize.deserialize().isEmpty()) continue;
                    Method serializeMethod = clazz.getMethod(specialSerialize.serialize(), field.getType());
                    Method deserializeMethod = clazz.getMethod(specialSerialize.deserialize(), serializeMethod.getReturnType());
                    field.set(object, deserializeMethod.invoke((Object)object, map.get(field.getName())));
                    continue;
                }
                field.set(object, map.get(field.getName()));
            }
            catch (Throwable e) {
                Bukkit.getLogger().warning(ChatColor.RED + "\u53d8\u91cf " + field.getName() + " \u53cd\u5e8f\u5217\u5316\u5931\u8d25");
            }
        }
        return object;
    }

    public static Map<String, Object> serialize(Object object) {
        return AutoSerializeImpl.serialize(object, object.getClass());
    }

    public static Map<String, Object> serialize(Object object, Class<?> clazz) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String clazzName = AutoSerializeImpl.getClassName(clazz);
        map.put("class", clazzName);
        map.put("==", nameOfAutoSerialize);
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.isAnnotationPresent(SpecialSerialize.class)) {
                    SpecialSerialize specialSerialize = field.getAnnotation(SpecialSerialize.class);
                    if (specialSerialize.serialize().isEmpty()) continue;
                    Method method = clazz.getMethod(specialSerialize.serialize(), field.getType());
                    map.put(field.getName(), method.invoke(object, field.get(object)));
                    continue;
                }
                map.put(field.getName(), field.get(object));
            }
            catch (Throwable e) {
                Bukkit.getLogger().warning(ChatColor.RED + "\u53d8\u91cf " + field.getName() + " \u5e8f\u5217\u5316\u5931\u8d25");
            }
        }
        return map;
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz.isAnnotationPresent(SerializeAs.class)) {
            return clazz.getAnnotation(SerializeAs.class).value();
        }
        return clazz.getName();
    }

    public static void registerClass(Class<? extends AutoSerialize> clazz) {
        classNames.put(AutoSerializeImpl.getClassName(clazz), clazz);
    }

    @Override
    public Map<String, Object> serialize() {
        return new HashMap<String, Object>();
    }

    static {
        classNames = new HashMap();
        nameOfAutoSerialize = JavaPlugin.getProvidingPlugin(AutoSerializeImpl.class).getName() + ".AutoSerialize";
        AutoSerializeImpl.register();
    }
}

