/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlFile
extends YamlConfiguration {
    private final File file;
    private long time = 0L;
    private boolean exists = true;
    private final boolean autoSave;
    private int isLoading = 0;

    public YamlFile(@NotNull File file, Plugin plugin, boolean autoReload, BiConsumer<YamlFile, Event> biConsumer, boolean autoSave) {
        this.file = file;
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            System.out.println("\u00a74[BluestarAPI]\u521b\u5efa\u6587\u4ef6\u65f6\u51fa\u9519:" + file.getName());
        }
        if (autoReload && biConsumer != null) {
            Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, () -> {
                if (file.exists() && !this.exists) {
                    this.exists = file.exists();
                    this.time = file.lastModified();
                    biConsumer.accept(this, Event.CREATE);
                } else if (!file.exists() && this.exists) {
                    this.exists = file.exists();
                    this.time = file.lastModified();
                    biConsumer.accept(this, Event.DELETE);
                } else if (this.exists && file.lastModified() != this.time) {
                    this.time = file.lastModified();
                    biConsumer.accept(this, Event.UPDATE);
                }
            }, 0L, 20L);
        }
        this.autoSave = autoSave;
    }

    public static Plugin getPlugin() {
        return JavaPlugin.getProvidingPlugin(YamlFile.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromString(@NotNull String contents) throws InvalidConfigurationException {
        YamlFile yamlFile = this;
        synchronized (yamlFile) {
            ++this.isLoading;
            try {
                super.loadFromString(contents);
            }
            finally {
                --this.isLoading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NotNull File file) throws IOException, InvalidConfigurationException {
        YamlFile yamlFile = this;
        synchronized (yamlFile) {
            ++this.isLoading;
            try {
                super.load(file);
            }
            finally {
                --this.isLoading;
            }
        }
    }

    public YamlFile(@NotNull File file, @NotNull Plugin plugin) {
        this(file, plugin, true);
    }

    public YamlFile(@NotNull File file, @NotNull Plugin plugin, boolean autoReload) {
        this(file, plugin, autoReload, (YamlFile yamlFile, Event event) -> {
            if (event == Event.UPDATE) {
                yamlFile.reload();
            }
        });
    }

    public YamlFile(@NotNull File file, @NotNull Plugin plugin, boolean autoReload, boolean autoSave) {
        this(file, plugin, autoReload, (YamlFile yamlFile, Event event) -> {
            if (event == Event.UPDATE) {
                yamlFile.reload();
            }
        }, autoSave);
    }

    public YamlFile(@NotNull File file, Plugin plugin, boolean autoReload, String message) {
        this(file, plugin, autoReload, message, true);
    }

    public YamlFile(@NotNull File file, Plugin plugin, boolean autoReload, BiConsumer<YamlFile, Event> biConsumer) {
        this(file, plugin, autoReload, biConsumer, true);
    }

    public YamlFile(@NotNull File file, Plugin plugin, boolean autoReload, String message, boolean autoSave) {
        this(file, plugin, autoReload, (YamlFile yamlFile, Event event) -> {
            if (event == Event.UPDATE) {
                yamlFile.reload();
                Bukkit.getLogger().info(message);
            }
        }, autoSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        YamlFile yamlFile = this;
        synchronized (yamlFile) {
            ++this.isLoading;
            try {
                super.load(reader);
            }
            finally {
                --this.isLoading;
            }
        }
    }

    @NotNull
    public YamlFile reload() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                System.out.println("\u00a74[BluestarAPI]\u521b\u5efa\u6587\u4ef6\u65f6\u51fa\u9519:" + this.file.getName());
                e.printStackTrace();
            }
        }
        try {
            this.loadFromString(new String(Files.readAllBytes(this.file.toPath())));
        }
        catch (IOException | InvalidConfigurationException e) {
            System.out.println("\u00a74[BluestarAPI]\u52a0\u8f7d\u6587\u4ef6\u65f6\u51fa\u9519:" + this.file.getName());
            e.printStackTrace();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NotNull String file) throws IOException, InvalidConfigurationException {
        YamlFile yamlFile = this;
        synchronized (yamlFile) {
            ++this.isLoading;
            try {
                super.load(file);
            }
            finally {
                --this.isLoading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NotNull String path, @Nullable Object value) {
        super.set(path, value);
        if (this.autoSave) {
            YamlFile yamlFile = this;
            synchronized (yamlFile) {
                if (this.isLoading == 0) {
                    this.save();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public YamlFile save() {
        YamlFile yamlFile = this;
        synchronized (yamlFile) {
            if (this.isLoading != 0) {
                YamlFile.getPlugin().getLogger().severe("\u00a74[BluestarAPI]\u6b63\u5728\u52a0\u8f7d\u6587\u4ef6,\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6:" + this.file.getName());
                return this;
            }
        }
        try {
            this.file.createNewFile();
            this.save(this.file);
        }
        catch (IOException e) {
            System.out.println("\u00a74[BluestarAPI]\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6:" + this.file.getName());
        }
        return this;
    }

    public static enum Event {
        UPDATE,
        DELETE,
        CREATE;

    }
}

