/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.inventory;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.nullaqua.api.config.AutoSerialize;
import me.nullaqua.api.reflect.FieldAccessor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemManager
implements Cloneable,
AutoSerialize {
    private static final FieldAccessor meta = FieldAccessor.getDeclaredField(ItemStack.class, "meta");
    private final ItemStack itemStack;

    public ItemManager(@NotNull Material type) {
        this(new ItemStack(type));
    }

    public ItemManager(ItemStack itemStack) {
        this.itemStack = itemStack;
        itemStack.setItemMeta(Bukkit.getItemFactory().getItemMeta(itemStack.getType()));
    }

    public ItemManager(@NotNull Material type, int amount) {
        this(new ItemStack(type, amount));
    }

    public ItemManager(@NotNull Material type, int amount, short damage) {
        this(new ItemStack(type, amount, damage));
    }

    public ItemManager(@NotNull Material type, int amount, short damage, @Nullable Byte data) {
        this(new ItemStack(type, amount, damage, data));
    }

    @NotNull
    public Material getType() {
        return this.itemStack.getType();
    }

    public ItemManager setType(@NotNull Material type) {
        this.itemStack.setType(type);
        return this;
    }

    public int getAmount() {
        return this.itemStack.getAmount();
    }

    public ItemManager setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Nullable
    public MaterialData getData() {
        return this.itemStack.getData();
    }

    public ItemManager setData(@Nullable MaterialData data) {
        this.itemStack.setData(data);
        return this;
    }

    public short getDurability() {
        return this.itemStack.getDurability();
    }

    public ItemManager setDurability(short durability) {
        this.itemStack.setDurability(durability);
        return this;
    }

    public int getMaxStackSize() {
        return this.itemStack.getMaxStackSize();
    }

    public boolean isSimilar(@Nullable ItemStack stack) {
        return this.itemStack.isSimilar(stack);
    }

    public int hashCode() {
        return this.itemStack.hashCode();
    }

    public boolean equals(Object obj) {
        return this.itemStack.equals(obj);
    }

    public ItemManager clone() {
        return new ItemManager(this.itemStack.clone());
    }

    public String toString() {
        return this.itemStack.toString();
    }

    public boolean containsEnchantment(@NotNull Enchantment ench) {
        return this.itemStack.containsEnchantment(ench);
    }

    public int getEnchantmentLevel(@NotNull Enchantment ench) {
        return this.itemStack.getEnchantmentLevel(ench);
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchantments() {
        return this.itemStack.getEnchantments();
    }

    public ItemManager addEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack.addEnchantments(enchantments);
        return this;
    }

    public ItemManager addEnchantment(@NotNull Enchantment ench, int level) {
        this.itemStack.addEnchantment(ench, level);
        return this;
    }

    public ItemManager addUnsafeEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack.addUnsafeEnchantments(enchantments);
        return this;
    }

    public ItemManager addUnsafeEnchantment(@NotNull Enchantment ench, int level) {
        this.itemStack.addUnsafeEnchantment(ench, level);
        return this;
    }

    public int removeEnchantment(@NotNull Enchantment ench) {
        return this.itemStack.removeEnchantment(ench);
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return this.itemStack.serialize();
    }

    public boolean hasItemMeta() {
        return this.itemStack.hasItemMeta();
    }

    public boolean hasDisplayName() {
        return this.getItemMeta().hasDisplayName();
    }

    @NotNull
    public ItemMeta getItemMeta() {
        try {
            ItemMeta itemMeta = (ItemMeta)meta.get(this.itemStack);
            if (itemMeta == null) {
                itemMeta = Bukkit.getItemFactory().getItemMeta(this.itemStack.getType());
                this.itemStack.setItemMeta(itemMeta);
            }
            return itemMeta;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NotNull
    public String getDisplayName() {
        return this.getItemMeta().getDisplayName();
    }

    public ItemManager setDisplayName(@Nullable String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setDisplayName(name);
        this.setItemMeta(itemMeta);
        return this;
    }

    public boolean setItemMeta(@Nullable ItemMeta itemMeta) {
        if (itemMeta == null) {
            this.itemStack.setItemMeta(Bukkit.getItemFactory().getItemMeta(this.itemStack.getType()));
            return true;
        }
        return this.itemStack.setItemMeta(itemMeta);
    }

    public boolean hasLocalizedName() {
        return this.getItemMeta().hasLocalizedName();
    }

    @NotNull
    public String getLocalizedName() {
        return this.getItemMeta().getLocalizedName();
    }

    public ItemManager setLocalizedName(@Nullable String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLocalizedName(name);
        this.setItemMeta(itemMeta);
        return this;
    }

    public boolean hasLore() {
        return this.getItemMeta().hasLore();
    }

    @Nullable
    public List<String> getLore() {
        return this.getItemMeta().getLore();
    }

    public ItemManager setLore(@Nullable List<String> lore) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLore(lore);
        this.setItemMeta(itemMeta);
        return this;
    }

    public boolean hasCustomModelData() {
        return this.getItemMeta().hasCustomModelData();
    }

    public int getCustomModelData() {
        return this.getItemMeta().getCustomModelData();
    }

    public ItemManager setCustomModelData(@Nullable Integer data) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setCustomModelData(data);
        this.setItemMeta(itemMeta);
        return this;
    }

    public boolean hasEnchants() {
        return this.getItemMeta().hasEnchants();
    }

    public boolean hasEnchant(@NotNull Enchantment ench) {
        return this.getItemMeta().hasEnchant(ench);
    }

    public int getEnchantLevel(@NotNull Enchantment ench) {
        return this.getItemMeta().getEnchantLevel(ench);
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchants() {
        return this.getItemMeta().getEnchants();
    }

    public boolean addEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.addEnchant(ench, level, ignoreLevelRestriction);
        this.setItemMeta(itemMeta);
        return b;
    }

    public boolean removeEnchant(@NotNull Enchantment ench) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.removeEnchant(ench);
        this.setItemMeta(itemMeta);
        return b;
    }

    public boolean hasConflictingEnchant(@NotNull Enchantment ench) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.hasConflictingEnchant(ench);
        this.setItemMeta(itemMeta);
        return b;
    }

    public ItemManager addItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
        return this;
    }

    public ItemManager removeItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.removeItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
        return this;
    }

    @NotNull
    public Set<ItemFlag> getItemFlags() {
        return this.getItemMeta().getItemFlags();
    }

    public boolean hasItemFlag(@NotNull ItemFlag flag) {
        return this.getItemMeta().hasItemFlag(flag);
    }

    public boolean isUnbreakable() {
        return this.getItemMeta().isUnbreakable();
    }

    public ItemManager setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setUnbreakable(unbreakable);
        this.setItemMeta(itemMeta);
        return this;
    }

    public boolean hasAttributeModifiers() {
        return this.getItemMeta().hasAttributeModifiers();
    }

    @Nullable
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.getItemMeta().getAttributeModifiers();
    }

    public ItemManager setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setAttributeModifiers(attributeModifiers);
        this.setItemMeta(itemMeta);
        return this;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot) {
        return this.getItemMeta().getAttributeModifiers(slot);
    }

    @Nullable
    public Collection<AttributeModifier> getAttributeModifiers(@NotNull Attribute attribute) {
        return this.getItemMeta().getAttributeModifiers(attribute);
    }

    public boolean addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.addAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return b;
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.removeAttributeModifier(attribute);
        this.setItemMeta(itemMeta);
        return b;
    }

    public boolean removeAttributeModifier(@NotNull EquipmentSlot slot) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.removeAttributeModifier(slot);
        this.setItemMeta(itemMeta);
        return b;
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean b = itemMeta.removeAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return b;
    }

    @NotNull
    public CustomItemTagContainer getCustomTagContainer() {
        return this.getItemMeta().getCustomTagContainer();
    }

    public ItemManager setVersion(int version) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setVersion(version);
        this.setItemMeta(itemMeta);
        return this;
    }
}

