/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import me.nullaqua.api.BluestarUtils;
import me.nullaqua.api.io.IOStreamKey;
import org.jetbrains.annotations.NotNull;

public final class IOAccessor
implements Serializable {
    private static final IOStreamKey.HexKey hexKey = new IOStreamKey.HexKey();

    private IOAccessor() {
    }

    public static IOStreamKey.XorKey randomXorKey() {
        return IOAccessor.xorKey(BluestarUtils.randomByte());
    }

    public static IOStreamKey.XorKey xorKey(byte b) {
        return new IOStreamKey.XorKey(b);
    }

    public static IOStreamKey.HexKey hexKey() {
        return hexKey;
    }

    public static IOStreamKey plusKeys(IOStreamKey ... key) {
        return IOStreamKey.plus(key);
    }

    public static void copyFile(File src, File dest) throws IOException {
        Files.newInputStream(src.toPath(), new OpenOption[0]).transferTo(Files.newOutputStream(dest.toPath(), new OpenOption[0]));
    }

    public static boolean validation(File file, File hashFile) {
        return file.exists() && hashFile.exists() && IOAccessor.readFile(hashFile).startsWith(IOAccessor.getHash(file));
    }

    @NotNull
    public static String getHash(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("sha-1");
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                int total;
                byte[] buffer = new byte[1024];
                while ((total = inputStream.read(buffer)) != -1) {
                    digest.update(buffer, 0, total);
                }
            }
            return IOAccessor.getHash(digest);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return "null (" + UUID.randomUUID() + ")";
        }
    }

    @NotNull
    public static String getHash(MessageDigest digest) {
        StringBuilder result = new StringBuilder();
        for (byte b : digest.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    @NotNull
    public static String readFile(File file) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string = IOAccessor.readFully(fileInputStream, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "null (" + UUID.randomUUID() + ")";
            }
        }
        fileInputStream.close();
        return string;
    }

    @NotNull
    public static String readFully(InputStream inputStream, Charset charset) throws IOException {
        return new String(IOAccessor.readFully(inputStream), charset);
    }

    @NotNull
    public static byte[] readFully(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            stream.write(buf, 0, len);
        }
        return stream.toByteArray();
    }
}

