/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io;

import java.io.Serializable;
import me.nullaqua.api.collection.ByteVector;

public abstract class IOStreamKey
implements Serializable {
    public static final IOStreamKey EmptyKey = new IOStreamKey(1){

        @Override
        public byte[] encrypt(byte b) {
            return new byte[]{b};
        }

        @Override
        public byte decrypt(byte[] bytes) {
            return bytes[0];
        }
    };
    private final int encryptNum;

    public IOStreamKey(int encryptNum) {
        this.encryptNum = encryptNum;
    }

    public abstract byte[] encrypt(byte var1);

    public abstract byte decrypt(byte[] var1);

    public int encryptNum() {
        return this.encryptNum;
    }

    public static IOStreamKey plus(final IOStreamKey ... keys) {
        if (keys == null || keys.length == 0) {
            return EmptyKey;
        }
        int sum = 1;
        for (IOStreamKey o : keys) {
            sum *= o.encryptNum();
        }
        return new IOStreamKey(sum){

            @Override
            public byte[] encrypt(byte b) {
                ByteVector res = new ByteVector();
                res.put(b);
                for (IOStreamKey o : keys) {
                    ByteVector x = new ByteVector();
                    for (byte b0 : res.toByteArray()) {
                        x.put(o.encrypt(b0));
                    }
                    res = x;
                }
                return res.toByteArray();
            }

            @Override
            public byte decrypt(byte[] bytes) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte[][] bytes1 = new byte[bytes.length / keys[i].encryptNum()][keys[i].encryptNum];
                    ByteVector res = new ByteVector();
                    for (int j = 0; j < bytes.length; ++j) {
                        bytes1[j / keys[i].encryptNum()][j % keys[i].encryptNum()] = bytes[j];
                    }
                    for (byte[] x : bytes1) {
                        res.put(keys[i].decrypt(x));
                    }
                    bytes = res.toByteArray();
                }
                return bytes[0];
            }
        };
    }

    public static class HexKey
    extends IOStreamKey {
        public HexKey() {
            super(2);
        }

        @Override
        public byte[] encrypt(byte b) {
            return new byte[]{HexKey.toHex((byte)(b >> 4)), HexKey.toHex(b)};
        }

        @Override
        public byte decrypt(byte[] bytes) {
            return (byte)(HexKey.fromHex(bytes[0]) << 4 | HexKey.fromHex(bytes[1]));
        }

        private static byte fromHex(byte x) {
            if (x >= 48 && x <= 57) {
                x = (byte)(x - 48);
                return x;
            }
            x = (byte)(x - 55);
            return x;
        }

        private static byte toHex(byte x) {
            if ((x = (byte)(x & 0xF)) > 9) {
                x = (byte)(x + 55);
                return x;
            }
            x = (byte)(x + 48);
            return x;
        }
    }

    public static class XorKey
    extends IOStreamKey {
        private final byte key;

        public XorKey(byte key) {
            super(1);
            this.key = key;
        }

        @Override
        public byte[] encrypt(byte bt) {
            return new byte[]{(byte)(bt ^ this.key)};
        }

        @Override
        public byte decrypt(byte[] bytes) {
            return (byte)(bytes[0] ^ this.key);
        }

        @Override
        public int encryptNum() {
            return 1;
        }
    }
}

