/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io;

import java.io.IOException;
import java.io.InputStream;
import me.nullaqua.api.io.IOAccessor;
import me.nullaqua.api.io.IOStreamKey;

public class KeyInputStream
extends InputStream {
    private final InputStream stream;
    private IOStreamKey key = IOStreamKey.EmptyKey;
    private final IOStreamKey baseKey;

    public KeyInputStream(InputStream stream) {
        this(stream, IOStreamKey.EmptyKey);
    }

    public KeyInputStream(InputStream stream, IOStreamKey baseKey) {
        this.stream = stream;
        this.baseKey = baseKey != null ? baseKey : IOStreamKey.EmptyKey;
    }

    public KeyInputStream key(IOStreamKey key) {
        this.key = key;
        return this;
    }

    public IOStreamKey key() {
        return this.key;
    }

    @Override
    public final int read() throws IOException {
        IOStreamKey key = this.getKey();
        byte[] bytes = new byte[key.encryptNum()];
        int read = this.stream.read(bytes);
        if (read == -1) {
            return -1;
        }
        if (read != key.encryptNum()) {
            throw new IOException("Read " + read + " bytes, but " + key.encryptNum() + " bytes expected.");
        }
        return key.decrypt(bytes);
    }

    private final IOStreamKey getKey() {
        if (this.key == null || this.key == IOStreamKey.EmptyKey) {
            return this.baseKey;
        }
        if (this.baseKey == null || this.baseKey == IOStreamKey.EmptyKey) {
            return this.key;
        }
        return IOAccessor.plusKeys(this.key, this.baseKey);
    }
}

