/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Objects;
import me.nullaqua.api.io.IOStreamKey;
import me.nullaqua.api.io.KeyInputStream;
import me.nullaqua.api.util.function.SupplierWithThrow;

public class KeyObjectInputStream
extends ObjectInputStream {
    private final KeyInputStream stream;
    private IOStreamKey defaultKey = IOStreamKey.EmptyKey;

    private KeyObjectInputStream(KeyInputStream stream) throws IOException {
        super(stream);
        this.stream = stream;
    }

    public static KeyObjectInputStream create(InputStream in) throws IOException {
        return new KeyObjectInputStream(new KeyInputStream(in));
    }

    public static KeyObjectInputStream create(InputStream in, IOStreamKey baseKey) throws IOException {
        return new KeyObjectInputStream(new KeyInputStream(in, baseKey));
    }

    public IOStreamKey defaultKey() {
        return this.defaultKey;
    }

    public KeyObjectInputStream defaultKey(IOStreamKey defaultKey) {
        this.defaultKey = !Objects.isNull(defaultKey) ? defaultKey : IOStreamKey.EmptyKey;
        this.stream.key(defaultKey);
        return this;
    }

    public Object readObject(IOStreamKey key) throws IOException, ClassNotFoundException {
        if (key == null) {
            key = this.defaultKey;
        }
        this.stream.key(key);
        try {
            Object object = super.readObject();
            return object;
        }
        finally {
            this.stream.key(this.defaultKey);
        }
    }

    public boolean readBoolean(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readBoolean(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithKey(SupplierWithThrow<T> run, IOStreamKey key) throws IOException {
        if (key == null) {
            key = this.defaultKey;
        }
        this.stream.key(key);
        try {
            T t = run.get(IOException.class);
            return t;
        }
        finally {
            this.stream.key(this.defaultKey);
        }
    }

    public byte readByte(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readByte(), key);
    }

    public int readUnsignedByte(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readUnsignedByte(), key);
    }

    public char readChar(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> Character.valueOf(super.readChar()), key).charValue();
    }

    public short readShort(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readShort(), key);
    }

    public int readUnsignedShort(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readUnsignedShort(), key);
    }

    public int readInt(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readInt(), key);
    }

    public long readLong(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readLong(), key);
    }

    public float readFloat(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> Float.valueOf(super.readFloat()), key).floatValue();
    }

    public double readDouble(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readDouble(), key);
    }

    public void readFully(byte[] buf, IOStreamKey key) throws IOException {
        this.readFully(buf, 0, buf.length, key);
    }

    public void readFully(byte[] buf, int off, int len, IOStreamKey key) throws IOException {
        this.runWithKey(() -> {
            super.readFully(buf, off, len);
            return 0;
        }, key);
    }

    public String readUTF(IOStreamKey key) throws IOException {
        return this.runWithKey(() -> super.readUTF(), key);
    }
}

