/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io;

import java.io.IOException;
import java.io.OutputStream;
import me.nullaqua.api.io.IOAccessor;
import me.nullaqua.api.io.IOStreamKey;

public class KeyOutputStream
extends OutputStream {
    private final OutputStream stream;
    private IOStreamKey key = IOStreamKey.EmptyKey;
    private final IOStreamKey baseKey;

    public KeyOutputStream(OutputStream stream) {
        this(stream, IOStreamKey.EmptyKey);
    }

    public KeyOutputStream(OutputStream stream, IOStreamKey baseKey) {
        this.stream = stream;
        this.baseKey = baseKey != null ? baseKey : IOStreamKey.EmptyKey;
    }

    public KeyOutputStream key(IOStreamKey key) {
        this.key = key;
        return this;
    }

    public IOStreamKey key() {
        return this.key;
    }

    @Override
    public final void write(int b) throws IOException {
        this.stream.write(this.getKey().encrypt((byte)b));
    }

    private final IOStreamKey getKey() {
        if (this.key == null || this.key == IOStreamKey.EmptyKey) {
            return this.baseKey;
        }
        if (this.baseKey == null || this.baseKey == IOStreamKey.EmptyKey) {
            return this.key;
        }
        return IOAccessor.plusKeys(this.key, this.baseKey);
    }
}

