/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;

public final class FileToImage {
    private FileToImage() {
    }

    public static void read(File from, File toDir) throws IOException {
        DataInputStream in = new DataInputStream(new ImageInputStream(ImageIO.read(from)));
        String name = in.readUTF();
        long length = in.readLong();
        File to = new File(toDir, name);
        try (OutputStream out = Files.newOutputStream(to.toPath(), new OpenOption[0]);){
            while (length-- > 0L) {
                out.write(in.read());
            }
        }
        catch (Throwable e) {
            to.delete();
            throw e;
        }
    }

    public static void write(File from, File to, int h, int w) throws IOException {
        try (InputStream in = Files.newInputStream(from.toPath(), new OpenOption[0]);){
            BufferedImage out = new BufferedImage(w, h, 6);
            DataOutputStream dout = new DataOutputStream(new ImageOutputStream(out));
            dout.writeUTF(from.getName());
            dout.writeLong(from.length());
            in.transferTo(dout);
            dout.close();
            ImageIO.write((RenderedImage)out, "png", to);
        }
    }

    private static class ImageInputStream
    extends InputStream {
        private final BufferedImage image;
        private int x;
        private int y;
        private int color;
        private int count;

        public ImageInputStream(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int read() throws EOFException {
            if (this.count == 0) {
                if (this.y == this.image.getHeight()) {
                    throw new EOFException();
                }
                this.color = this.image.getRGB(this.x, this.y);
                ++this.x;
                if (this.x == this.image.getWidth()) {
                    this.x = 0;
                    ++this.y;
                }
            }
            int b = this.color >> 8 * this.count & 0xFF;
            ++this.count;
            if (this.count == 4) {
                this.count = 0;
            }
            return b;
        }

        @Override
        public int available() {
            return this.image.getWidth() * this.image.getHeight() * 4;
        }

        @Override
        public void close() {
            this.image.flush();
        }
    }

    private static class ImageOutputStream
    extends OutputStream {
        private final BufferedImage image;
        private int x;
        private int y;
        private int color;
        private int count;

        public ImageOutputStream(BufferedImage image) {
            this.image = image;
        }

        @Override
        public void write(int b) throws IOException {
            this.color |= (b & 0xFF) << 8 * this.count;
            ++this.count;
            if (this.count == 4) {
                if (this.y == this.image.getHeight()) {
                    throw new ImageTooSmallException();
                }
                this.image.setRGB(this.x, this.y, this.color);
                ++this.x;
                if (this.x == this.image.getWidth()) {
                    this.x = 0;
                    ++this.y;
                }
                this.count = 0;
                this.color = 0;
            }
        }

        @Override
        public void close() {
            this.flush();
            this.image.flush();
        }

        @Override
        public void flush() {
            if (this.count != 0) {
                this.image.setRGB(this.x, this.y, this.color);
            }
        }
    }

    public static class ImageTooSmallException
    extends IOException {
        public ImageTooSmallException() {
            super("Image too small");
        }
    }
}

