/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io.file;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import me.nullaqua.api.io.IOStreamKey;
import me.nullaqua.api.io.KeyObjectInputStream;
import me.nullaqua.api.io.file.ReadVersion;
import me.nullaqua.api.io.file.UnknownFileVersionException;
import me.nullaqua.api.reflect.MethodAccessor;

public class FileWithVersionReader {
    private final File file;

    public FileWithVersionReader(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FileWithVersionReader that = (FileWithVersionReader)obj;
        return Objects.equals(this.file, that.file);
    }

    public String toString() {
        return "FileWithVersionReader[file=" + this.file + "]";
    }

    public boolean read(Worker worker) {
        return this.read(worker, IOStreamKey.EmptyKey);
    }

    public boolean read(Worker worker, IOStreamKey key) {
        return this.read(worker, key, IOStreamKey.EmptyKey);
    }

    public boolean read(Worker worker, IOStreamKey key, IOStreamKey baseKey) {
        boolean bl;
        block18: {
            KeyObjectInputStream stream2 = KeyObjectInputStream.create(Files.newInputStream(this.file.toPath(), new OpenOption[0]), baseKey);
            try {
                String version = (String)stream2.readObject(key);
                MethodAccessor method = FileWithVersionReader.getWorkMethod(worker, version);
                if (method == null) {
                    worker.defaultRead(version, stream2);
                } else {
                    method.invoke(worker, stream2);
                }
                bl = true;
                if (stream2 == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable stream2) {
                    boolean bl2;
                    block19: {
                        KeyObjectInputStream stream3 = KeyObjectInputStream.create(Files.newInputStream(this.file.toPath(), new OpenOption[0]), baseKey);
                        try {
                            worker.defaultRead(null, stream3);
                            bl2 = true;
                            if (stream3 == null) break block19;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (stream3 != null) {
                                    try {
                                        stream3.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable5) {
                                return false;
                            }
                        }
                        stream3.close();
                    }
                    return bl2;
                }
            }
            stream2.close();
        }
        return bl;
    }

    private static MethodAccessor getWorkMethod(Worker worker, String ver) {
        for (Method method : worker.getClass().getDeclaredMethods()) {
            ReadVersion readVersion = method.getAnnotation(ReadVersion.class);
            if (readVersion == null || !readVersion.value().equals(ver) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(KeyObjectInputStream.class)) continue;
            return new MethodAccessor(method);
        }
        return null;
    }

    public static interface Worker {
        default public void defaultRead(String version, KeyObjectInputStream stream) {
            throw new UnknownFileVersionException();
        }
    }
}

