/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.io.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import me.nullaqua.api.io.IOStreamKey;
import me.nullaqua.api.io.KeyObjectOutputStream;
import me.nullaqua.api.util.function.ConsumerWithThrow;

public class FileWithVersionWriter {
    private final File file;

    public FileWithVersionWriter(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public void saveFile(String ver, ConsumerWithThrow<KeyObjectOutputStream> consumer) throws IOException {
        this.saveFile(IOStreamKey.EmptyKey, ver, consumer);
    }

    public void saveFile(IOStreamKey key, String ver, ConsumerWithThrow<KeyObjectOutputStream> consumer) throws IOException {
        this.saveFile(key, IOStreamKey.EmptyKey, ver, consumer);
    }

    public void saveFile(IOStreamKey key, IOStreamKey baseKey, String ver, ConsumerWithThrow<KeyObjectOutputStream> consumer) throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        if (this.file.isDirectory()) {
            throw new IOException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25,\u5df2\u6709\u91cd\u540d\u6587\u4ef6\u5939");
        }
        try (KeyObjectOutputStream koos = KeyObjectOutputStream.create(new FileOutputStream(this.file), baseKey);){
            koos.writeObject(ver, key);
            if (!Objects.isNull(consumer)) {
                consumer.accept(koos, IOException.class);
            }
        }
    }
}

