/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import me.nullaqua.api.math.Variable;

public final class Calculator {
    private final Map<String, Variable> variables = new HashMap<String, Variable>();

    private static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    private static boolean isNum(char s) {
        return s >= '0' && s <= '9' || s == '.';
    }

    private static boolean isOperator(char s) {
        return "+-*/()".contains("" + s);
    }

    public void putItem(Variable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public Set<Variable> getItems() {
        return new HashSet<Variable>(this.variables.values());
    }

    public Variable removeItem(Variable variable) {
        return this.variables.remove(variable.getName());
    }

    public Result calculator(String str) {
        str = str.replace('\uff08', '(').replace('\uff09', '(').replace('\u00d7', '*').replace('\u00f7', '/');
        str = Calculator.toDBC(str);
        Stack<Character> a = new Stack<Character>();
        Stack<Object> stack = new Stack<Object>();
        HashMap<Number, Long> items = new HashMap<Number, Long>();
        for (int i = 0; i < str.length(); ++i) {
            if (!Calculator.isOperator(str.charAt(i))) {
                StringBuilder s = new StringBuilder();
                while (i < str.length() && !Calculator.isOperator(str.charAt(i))) {
                    s.append(str.charAt(i));
                    ++i;
                }
                --i;
                try {
                    Long l = (Long)items.get(Double.parseDouble(s.toString()));
                    if (l == null) {
                        l = 0L;
                    }
                    l = l + 1L;
                    items.put(Double.parseDouble(s.toString()), l);
                    stack.push(s.toString());
                }
                catch (Exception e) {
                    Variable variable = this.variables.get(s.toString());
                    if (variable == null) {
                        return new Result(new HashMap(), true, false, null);
                    }
                    Long l = (Long)items.get(variable);
                    if (l == null) {
                        l = 0L;
                    }
                    l = l + 1L;
                    items.put(variable, l);
                    stack.push(String.valueOf(variable.vault()));
                }
                continue;
            }
            if ("(".indexOf(str.charAt(i)) >= 0) {
                a.push(Character.valueOf(str.charAt(i)));
                continue;
            }
            if (")".indexOf(str.charAt(i)) >= 0) {
                while (((Character)a.peek()).charValue() != '(') {
                    stack.push("" + a.pop());
                }
                a.pop();
                continue;
            }
            if ("*/".indexOf(str.charAt(i)) >= 0) {
                if (a.isEmpty()) {
                    a.push(Character.valueOf(str.charAt(i)));
                    continue;
                }
                if ("*/".indexOf(((Character)a.peek()).charValue()) >= 0) {
                    stack.push("" + a.pop());
                    a.push(Character.valueOf(str.charAt(i)));
                    continue;
                }
                if ("(".indexOf(((Character)a.peek()).charValue()) == 0) {
                    a.push(Character.valueOf(str.charAt(i)));
                    continue;
                }
                if ("+-".indexOf(((Character)a.peek()).charValue()) < 0) continue;
                a.push(Character.valueOf(str.charAt(i)));
                continue;
            }
            if ("+-".indexOf(str.charAt(i)) < 0) continue;
            if (a.isEmpty()) {
                a.push(Character.valueOf(str.charAt(i)));
                continue;
            }
            if ("*/".indexOf(((Character)a.peek()).charValue()) >= 0) {
                stack.push("" + a.pop());
                a.push(Character.valueOf(str.charAt(i)));
                continue;
            }
            if ("(".indexOf(((Character)a.peek()).charValue()) >= 0) {
                a.push(Character.valueOf(str.charAt(i)));
                continue;
            }
            if ("+-".indexOf(((Character)a.peek()).charValue()) < 0) continue;
            stack.push("" + a.pop());
            a.push(Character.valueOf(str.charAt(i)));
        }
        while (!a.isEmpty()) {
            stack.push("" + a.pop());
        }
        Stack<String> ans = new Stack<String>();
        while (!stack.isEmpty()) {
            ans.push((String)stack.pop());
        }
        Result result = this.work(ans);
        return new Result(items, result.formatErr, result.mathErr, result.ans);
    }

    public Result work(Stack<String> str) {
        if (str == null) {
            return new Result(new HashMap(), false, false, null);
        }
        Stack<String> result = new Stack<String>();
        while (!str.isEmpty()) {
            if (!"+-*/".contains(str.peek())) {
                result.push(str.peek());
            }
            if ("+-*/".contains(str.peek())) {
                double n;
                if (result.isEmpty()) {
                    return new Result(new HashMap(), true, false, null);
                }
                double x = Double.parseDouble((String)result.pop());
                if (result.isEmpty()) {
                    return new Result(new HashMap(), true, false, null);
                }
                double y = Double.parseDouble((String)result.pop());
                if ("-".contains(str.peek())) {
                    n = y - x;
                    result.push(String.valueOf(n));
                }
                if ("+".contains(str.peek())) {
                    n = y + x;
                    result.push(String.valueOf(n));
                }
                if ("*".contains(str.peek())) {
                    n = y * x;
                    result.push(String.valueOf(n));
                }
                if ("/".contains(str.peek())) {
                    if (x == 0.0) {
                        return new Result(new HashMap(), false, true, null);
                    }
                    n = y / x;
                    result.push(String.valueOf(n));
                }
            }
            str.pop();
        }
        return new Result(new HashMap(), false, false, Double.parseDouble((String)result.pop()));
    }

    public static class Result {
        private final Map<Number, Long> item;
        private final List<Number> itemList;
        private final boolean formatErr;
        private final boolean mathErr;
        private final Double ans;

        private Result(Map<Number, Long> item, boolean formatErr, boolean mathErr, Double ans) {
            this.item = item;
            this.formatErr = formatErr;
            this.mathErr = mathErr;
            this.ans = ans;
            this.itemList = new ArrayList<Number>();
            for (Map.Entry<Number, Long> entry : item.entrySet()) {
                int i = 0;
                while ((long)i < entry.getValue()) {
                    this.itemList.add(entry.getKey());
                    ++i;
                }
            }
        }

        public boolean hasError() {
            return this.formatErr || this.mathErr;
        }

        public boolean hasFormatErr() {
            return this.formatErr;
        }

        public boolean hasMathErr() {
            return this.mathErr;
        }

        public Double getAnswer() {
            return this.ans;
        }

        public Map<Number, Long> getItem() {
            return new HashMap<Number, Long>(this.item);
        }

        public List<Number> getItemInList() {
            return new ArrayList<Number>(this.itemList);
        }

        public String toString() {
            if (this.hasError()) {
                return "Calculator.Result{ HasError: " + (this.hasFormatErr() ? "FormatErr" : "MathErr") + " }";
            }
            return "Calculator.Result{ ans: " + this.getAnswer() + ",items: " + this.getItemInList().toString() + " }";
        }
    }
}

