/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class Fraction
extends Number
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigInteger numerator;
    private BigInteger denominator;

    public Fraction(long numerator, long denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public Fraction(BigInteger numerator, BigInteger denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.reduce();
    }

    public void reduce() {
        BigInteger gcd = this.numerator.gcd(this.denominator);
        this.numerator = this.numerator.divide(gcd);
        this.denominator = this.denominator.divide(gcd);
        if (this.denominator.compareTo(BigInteger.ZERO) < 0) {
            this.numerator = this.numerator.negate();
            this.denominator = this.denominator.negate();
        }
    }

    public Fraction(int numerator, int denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public Fraction(double value) {
        this(value, 1.0E-10);
    }

    public Fraction(double value, double epsilon) {
        long h1 = 1L;
        long h2 = 0L;
        long k1 = 0L;
        long k2 = 1L;
        double b = value;
        do {
            double a = Math.floor(b);
            long aux = h1;
            h1 = (long)(a * (double)h1 + (double)h2);
            h2 = aux;
            aux = k1;
            k1 = (long)(a * (double)k1 + (double)k2);
            k2 = aux;
            b = 1.0 / (b - a);
        } while (Math.abs(value - (double)(h1 / k1)) > value * epsilon);
        this.numerator = BigInteger.valueOf(h1);
        this.denominator = BigInteger.valueOf(k1);
        this.reduce();
    }

    public Fraction(int value) {
        this(BigInteger.valueOf(value), BigInteger.ONE);
    }

    public Fraction(long value) {
        this(BigInteger.valueOf(value), BigInteger.ONE);
    }

    public Fraction(BigInteger value) {
        this(value, BigInteger.ONE);
    }

    public Fraction(String value) {
        String[] parts = value.split("/");
        if (parts.length == 1) {
            this.numerator = new BigInteger(parts[0]);
            this.denominator = BigInteger.ONE;
        } else if (parts.length == 2) {
            this.numerator = new BigInteger(parts[0]);
            this.denominator = new BigInteger(parts[1]);
        } else {
            throw new IllegalArgumentException("Invalid fraction value: " + value);
        }
        this.reduce();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    @Override
    public int intValue() {
        return this.toInt();
    }

    public int toInt() {
        return this.numerator.intValue() / this.denominator.intValue();
    }

    @Override
    public long longValue() {
        return this.toLong();
    }

    public long toLong() {
        return this.numerator.longValue() / this.denominator.longValue();
    }

    @Override
    public float floatValue() {
        return this.toFloat();
    }

    public float toFloat() {
        return this.numerator.floatValue() / this.denominator.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.toDouble();
    }

    public double toDouble() {
        return this.numerator.doubleValue() / this.denominator.doubleValue();
    }

    public Fraction add(Fraction fraction) {
        return new Fraction(this.numerator.multiply(fraction.denominator).add(this.denominator.multiply(fraction.numerator)), this.denominator.multiply(fraction.denominator));
    }

    public Fraction subtract(Fraction fraction) {
        return new Fraction(this.numerator.multiply(fraction.denominator).subtract(this.denominator.multiply(fraction.numerator)), this.denominator.multiply(fraction.denominator));
    }

    public Fraction multiply(Fraction fraction) {
        return new Fraction(this.numerator.multiply(fraction.numerator), this.denominator.multiply(fraction.denominator));
    }

    public Fraction divide(Fraction fraction) {
        return new Fraction(this.numerator.multiply(fraction.denominator), this.denominator.multiply(fraction.numerator));
    }

    public Fraction negate() {
        return new Fraction(this.numerator.negate(), this.denominator);
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction abs() {
        return new Fraction(this.numerator.abs(), this.denominator.abs());
    }

    public Fraction pow(int exponent) {
        return new Fraction(this.numerator.pow(exponent), this.denominator.pow(exponent));
    }

    public Fraction max(Fraction fraction) {
        return new Fraction(this.numerator.max(fraction.numerator), this.denominator.max(fraction.denominator));
    }

    public Fraction min(Fraction fraction) {
        return new Fraction(this.numerator.min(fraction.numerator), this.denominator.min(fraction.denominator));
    }

    public boolean equals(Object fraction) {
        if (fraction instanceof Fraction) {
            return this.compareTo((Fraction)fraction) == 0;
        }
        return false;
    }

    public int compareTo(Fraction fraction) {
        return this.numerator.multiply(fraction.denominator).compareTo(this.denominator.multiply(fraction.numerator));
    }

    public int hashCode() {
        return this.numerator.hashCode() * this.denominator.hashCode();
    }

    public Fraction clone() {
        return new Fraction(this.numerator, this.denominator);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.numerator);
        out.writeObject(this.denominator);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.numerator = (BigInteger)in.readObject();
        this.denominator = (BigInteger)in.readObject();
    }
}

