/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.math;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Variable
extends Number {
    private final String name;
    private Number vault;

    private Variable(String name, Number vault) {
        this.name = name;
        this.vault = vault;
        this.check();
    }

    private void check() {
        Number var = this.vault();
        while (var instanceof Variable) {
            if (var == this) {
                throw new AssertionError((Object)"\u53d8\u91cf\u5faa\u73af\u5f15\u7528");
            }
            var = ((Variable)var).vault();
        }
    }

    public static Variable create(String name, Number vault) {
        try {
            Double.parseDouble(name);
            throw new AssertionError((Object)"\u53d8\u91cf\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        catch (Exception exception) {
            return new Variable(name, vault);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Number vault() {
        Variable variable = this;
        synchronized (variable) {
            return this.vault;
        }
    }

    public Variable vault(Number vault) {
        if (Objects.nonNull(vault)) {
            this.vault = vault;
        }
        return this;
    }

    @Override
    public int intValue() {
        return this.vault().intValue();
    }

    @Override
    public long longValue() {
        return this.vault().longValue();
    }

    @Override
    public float floatValue() {
        return this.vault().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.vault().doubleValue();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "{Variable: " + this.name + " }";
    }
}

