/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.nbt;

import me.nullaqua.api.nbt.NBTCompound;
import me.nullaqua.api.nbt.NBTPersistentDataContainer;
import me.nullaqua.api.nbt.NBTReflectionUtil;
import me.nullaqua.api.nbt.NbtApiException;
import me.nullaqua.api.nbt.utils.MinecraftVersion;
import me.nullaqua.api.nbt.utils.annotations.AvailableSince;
import me.nullaqua.api.nbt.utils.annotations.CheckUtil;
import me.nullaqua.api.nbt.utils.annotations.FAUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("Entity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("Entity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        return new NBTPersistentDataContainer(this.ent.getPersistentDataContainer());
    }
}

