/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.nullaqua.api.io.IOAccessor;
import me.nullaqua.api.net.AbstractXmlParser;
import me.nullaqua.api.net.MavenPacket;
import me.nullaqua.api.net.Repository;
import me.nullaqua.api.reflect.URLClassLoaderAccessor;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenLoader
extends AbstractXmlParser {
    private static final URLClassLoaderAccessor loaderAccessor;
    private static final Set<MavenPacket> injectedDependencies;
    private static final Set<MavenPacket> downloadedDependencies;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final File baseDir;
    private MavenPacket.MavenPacketScope[] dependencyScopes = new MavenPacket.MavenPacketScope[]{MavenPacket.MavenPacketScope.RUNTIME, MavenPacket.MavenPacketScope.COMPILE};
    private boolean ignoreOptional = true;
    private boolean ignoreException = false;
    private boolean isTransitive = true;

    public static void loadJar(File jarFile) throws IOException {
        MavenLoader.loadJar(jarFile, null);
    }

    public static void loadJar(File jarFile, URLClassLoader classLoader) throws IOException {
        URLClassLoaderAccessor accessor = classLoader == null ? loaderAccessor : new URLClassLoaderAccessor(classLoader);
        try {
            accessor.addURL(jarFile.toURI().toURL());
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public MavenLoader(@Nullable File baseDir) {
        this.baseDir = baseDir;
    }

    public void injectClasspath(Set<MavenPacket> dependencies) throws IOException {
        this.injectClasspath(dependencies, null);
    }

    public void injectClasspath(Set<MavenPacket> dependencies, URLClassLoader loader) throws IOException {
        for (MavenPacket dep : dependencies) {
            if (injectedDependencies.contains(dep)) continue;
            File file = dep.findFile(this.baseDir, "jar");
            if (file.exists()) {
                MavenLoader.loadJar(file, loader);
                injectedDependencies.add(dep);
                continue;
            }
            try {
                this.loadDependency(this.repositories, dep);
                this.injectClasspath(Collections.singleton(dep), loader);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load dependency: " + dep, e);
            }
        }
    }

    public Set<MavenPacket> loadDependencyFromInputStream(InputStream pom, MavenPacket.MavenPacketScope ... scopes) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xml = builder.parse(pom);
            return this.loadDependencyFromPom(xml, scopes);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Unable to load pom.xml parser", ex);
        }
        catch (SAXException ex) {
            throw new IOException("Unable to parse pom.xml", ex);
        }
    }

    public Set<MavenPacket> loadDependencyFromPom(Document pom, MavenPacket.MavenPacketScope ... scopes) throws IOException {
        ArrayList<Repository> repos;
        ArrayList<MavenPacket> dependencies;
        block10: {
            int i;
            dependencies = new ArrayList<MavenPacket>();
            HashSet<MavenPacket.MavenPacketScope> scopeSet = new HashSet<MavenPacket.MavenPacketScope>(Arrays.asList(scopes));
            NodeList nodes = pom.getDocumentElement().getChildNodes();
            repos = new ArrayList<Repository>(this.repositories);
            if (repos.isEmpty()) {
                repos.add(new Repository());
            }
            try {
                for (i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!node.getNodeName().equals("repositories")) continue;
                    nodes = ((Element)node).getElementsByTagName("repository");
                    for (i = 0; i < nodes.getLength(); ++i) {
                        Element e = (Element)nodes.item(i);
                        repos.add(new Repository(e));
                    }
                    break;
                }
            }
            catch (ParseException ex) {
                throw new IOException("Unable to parse repositories", ex);
            }
            if (this.isTransitive) {
                nodes = pom.getElementsByTagName("dependency");
                try {
                    for (i = 0; i < nodes.getLength(); ++i) {
                        MavenPacket dep;
                        if (this.ignoreOptional && MavenLoader.find("optional", (Element)nodes.item(i), "false").equals("true") || !scopeSet.contains((Object)(dep = new MavenPacket((Element)nodes.item(i))).getScope())) continue;
                        dependencies.add(dep);
                    }
                }
                catch (ParseException ex) {
                    if (this.ignoreException) break block10;
                    throw new IOException("Unable to parse dependencies", ex);
                }
            }
        }
        return this.loadDependency(repos, dependencies);
    }

    public Set<MavenPacket> loadDependency(List<Repository> repositories, List<MavenPacket> dependencies) throws IOException {
        this.createBaseDir();
        HashSet<MavenPacket> downloaded = new HashSet<MavenPacket>();
        for (MavenPacket dep : dependencies) {
            downloaded.addAll(this.loadDependency(repositories, dep));
        }
        return downloaded;
    }

    private void createBaseDir() {
        this.baseDir.mkdirs();
    }

    public Set<MavenPacket> loadDependency(Collection<Repository> repositories, MavenPacket dependency) throws IOException {
        if (repositories.isEmpty()) {
            throw new IllegalArgumentException("No repositories specified");
        }
        if (downloadedDependencies.contains(dependency)) {
            HashSet<MavenPacket> singleton = new HashSet<MavenPacket>();
            singleton.add(dependency);
            return singleton;
        }
        File pom = dependency.findFile(this.baseDir, "pom");
        File pom1 = new File(pom.getPath() + ".sha1");
        File jar = dependency.findFile(this.baseDir, "jar");
        File jar1 = new File(jar.getPath() + ".sha1");
        HashSet<MavenPacket> downloaded = new HashSet<MavenPacket>();
        downloaded.add(dependency);
        if (IOAccessor.validation(pom, pom1) && IOAccessor.validation(jar, jar1)) {
            downloadedDependencies.add(dependency);
            if (pom.exists()) {
                downloaded.addAll(this.loadDependencyFromInputStream(pom.toURI().toURL().openStream()));
            }
            return downloaded;
        }
        pom.getParentFile().mkdirs();
        IOException e = null;
        for (Repository repo : repositories) {
            try {
                System.err.println("tryDownload: " + repo.getUrl());
                repo.downloadFile(dependency, pom);
                repo.downloadFile(dependency, jar);
                e = null;
                break;
            }
            catch (Exception ex) {
                e = new IOException(String.format("Unable to find download for %s (%s)", dependency, repo.getUrl()), ex);
            }
        }
        if (e != null) {
            throw e;
        }
        return downloaded;
    }

    public Set<MavenPacket> loadDependencyFromInputStream(InputStream pom) throws IOException {
        return this.loadDependencyFromInputStream(pom, this.dependencyScopes);
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public MavenPacket.MavenPacketScope[] getDependencyScopes() {
        return this.dependencyScopes;
    }

    public MavenLoader setDependencyScopes(MavenPacket.MavenPacketScope[] dependencyScopes) {
        this.dependencyScopes = dependencyScopes;
        return this;
    }

    public Set<MavenPacket> getInjectedDependencies() {
        return injectedDependencies;
    }

    public Set<Repository> getRepositories() {
        return this.repositories;
    }

    public boolean isIgnoreOptional() {
        return this.ignoreOptional;
    }

    public MavenLoader setIgnoreOptional(boolean ignoreOptional) {
        this.ignoreOptional = ignoreOptional;
        return this;
    }

    public MavenLoader setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
        return this;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void setTransitive(boolean transitive) {
        this.isTransitive = transitive;
    }

    static {
        if (MavenLoader.class.getClassLoader() instanceof URLClassLoader) {
            loaderAccessor = new URLClassLoaderAccessor((URLClassLoader)MavenLoader.class.getClassLoader());
        } else {
            URLClassLoader loader = new URLClassLoader(new URL[0], MavenLoader.class.getClassLoader());
            loaderAccessor = new URLClassLoaderAccessor(loader);
        }
        injectedDependencies = new HashSet<MavenPacket>();
        downloadedDependencies = new HashSet<MavenPacket>();
    }
}

