/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.net;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.nullaqua.api.net.AbstractXmlParser;
import me.nullaqua.api.net.Repository;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class MavenPacket
extends AbstractXmlParser {
    private static final String LATEST_VERSION = "latest";
    private final String groupId;
    private final String artifactId;
    private final MavenPacketScope scope;
    private String version;

    public MavenPacket(Element node) throws ParseException {
        this(MavenPacket.find("groupId", node), MavenPacket.find("artifactId", node), MavenPacket.find("version", node, LATEST_VERSION), MavenPacketScope.valueOf(MavenPacket.find("scope", node, "runtime").toUpperCase()));
    }

    public MavenPacket(String groupId, String artifactId, String version, MavenPacketScope scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version.contains("$") || version.contains("[") || version.contains("(") ? LATEST_VERSION : version;
        this.scope = scope;
    }

    public URL getURL(Repository repo, String ext) throws MalformedURLException {
        String name = String.format("%s-%s.%s", this.getArtifactId(), this.getVersion(), ext);
        return new URL(String.format("%s/%s/%s/%s/%s", repo.getUrl(), this.getGroupId().replace('.', '/'), this.getArtifactId(), this.getVersion(), name));
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version.equals(LATEST_VERSION) ? null : this.version;
    }

    public void setVersion(String version) {
        if (!this.version.equals(LATEST_VERSION)) {
            throw new IllegalStateException("Version is already resolved");
        }
        if (version.equals(LATEST_VERSION)) {
            throw new IllegalArgumentException("Cannot set version to the latest");
        }
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public DependencyVersion getInstalledLatestVersion(File baseDir) {
        DependencyVersion max = null;
        for (DependencyVersion ver : this.getInstalledVersions(baseDir)) {
            if (max != null && ver.compareTo(max) <= 0) continue;
            max = ver;
        }
        return max;
    }

    public DependencyVersion[] getInstalledVersions(File dir) {
        for (String part : this.getGroupId().split("\\.")) {
            dir = new File(dir, part);
        }
        String[] list = (dir = new File(dir, this.getArtifactId())).list();
        if (list == null) {
            return new DependencyVersion[0];
        }
        DependencyVersion[] versions = new DependencyVersion[list.length];
        for (int i = 0; i < list.length; ++i) {
            versions[i] = new DependencyVersion(list[i]);
        }
        return versions;
    }

    public File findFile(File dir, String ext) {
        if (this.getVersion() == null) {
            throw new IllegalStateException("Version is not resolved: " + this);
        }
        for (String part : this.getGroupId().split("\\.")) {
            dir = new File(dir, part);
        }
        dir = new File(dir, this.getArtifactId());
        dir = new File(dir, this.getVersion());
        dir = new File(dir, String.format("%s-%s.%s", this.getArtifactId(), this.getVersion(), ext));
        return dir;
    }

    public MavenPacketScope getScope() {
        return this.scope;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenPacket)) {
            return false;
        }
        MavenPacket that = (MavenPacket)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getVersion(), that.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId());
    }

    public static enum MavenPacketScope {
        COMPILE,
        PROVIDED,
        RUNTIME,
        TEST,
        SYSTEM,
        IMPORT;

    }

    public static class DependencyVersion
    implements Comparable<DependencyVersion> {
        private final List<Integer> parts = new ArrayList<Integer>();
        private final String version;

        public DependencyVersion(String version) {
            for (String part : version.split("[^0-9]")) {
                if (part.isEmpty()) continue;
                this.parts.add(Integer.parseInt(part));
            }
            this.version = version;
        }

        @Override
        public int compareTo(DependencyVersion o) {
            Iterator<Integer> us = this.parts.iterator();
            Iterator<Integer> them = o.parts.iterator();
            while (us.hasNext() && them.hasNext()) {
                int diff = us.next().compareTo(them.next());
                if (diff == 0) continue;
                return diff;
            }
            return us.hasNext() ? 1 : (them.hasNext() ? -1 : 0);
        }

        public String toString() {
            return this.version;
        }
    }
}

