/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.net.dowloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Consumer;
import me.nullaqua.api.net.dowloader.Downloader;

public class DefaultDownload {
    public static DefaultDownloader download(String serverPath, String localPath) throws IOException {
        return DefaultDownload.download(serverPath, localPath, -1);
    }

    public static DefaultDownloader download(String serverPath, String localPath, int timeOut) throws IOException {
        File file = new File(localPath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        URL url = new URL(serverPath);
        URLConnection conn = url.openConnection();
        if (timeOut > 0) {
            conn.setConnectTimeout(timeOut);
            conn.setReadTimeout(timeOut);
        }
        DefaultDownloader downloader = new DefaultDownloader(conn.getContentLengthLong(), localPath);
        new Thread(() -> {
            try (InputStream inputStream = conn.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(file);){
                DefaultDownload.copy(inputStream, outputStream, downloader::add, downloader);
                if (downloader.status() == Downloader.Status.Cancel || downloader.status() == Downloader.Status.Error) {
                    outputStream.close();
                    file.delete();
                } else {
                    downloader.setSuccess();
                }
            }
            catch (Throwable e) {
                downloader.error(e);
            }
        }).start();
        return downloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream in, OutputStream out, Consumer<Long> add, Downloader manager) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            Downloader downloader = manager;
            synchronized (downloader) {
                while (manager.pause()) {
                    try {
                        manager.wait();
                    }
                    catch (Throwable throwable) {}
                }
                if (!manager.running()) {
                    break;
                }
            }
            out.write(buffer, 0, len);
            add.accept(Long.valueOf(len));
        }
    }

    private static class DefaultDownloader
    extends Downloader {
        public DefaultDownloader(long totalSize, String file) {
            super(totalSize, file);
        }
    }
}

