/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.net.dowloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import me.nullaqua.api.collection.FastLinkedList;
import me.nullaqua.api.net.dowloader.DefaultDownload;
import me.nullaqua.api.net.dowloader.MultiThreadDownload;
import me.nullaqua.api.util.quantity.DataRate;
import me.nullaqua.api.util.quantity.DataSize;
import me.nullaqua.api.util.quantity.Time;
import me.nullaqua.api.util.quantity.unit.DataRateUnit;
import me.nullaqua.api.util.quantity.unit.DataSizeUnit;
import me.nullaqua.api.util.quantity.unit.TimeUnit;

public abstract class Downloader {
    private final FastLinkedList<Map.Entry<Long, Long>> time;
    private final String file;
    private Status status;
    private final long totalSize;
    private final long startTime;
    private long speed = 0L;
    private long currentSize;
    private Throwable errorCause;
    private DownloadData data;

    Downloader(long totalSize, String file) {
        this.totalSize = totalSize;
        this.time = new FastLinkedList();
        this.currentSize = 0L;
        this.startTime = System.currentTimeMillis();
        this.file = file;
        this.status = Status.Running;
    }

    public static Downloader download(String serverPath, String savePath) {
        return Downloader.download(serverPath, savePath, -1, -1);
    }

    public static Downloader download(String url, String savePath, int threadCount, int timeOut) {
        if (threadCount > 1) {
            try {
                return MultiThreadDownload.download(threadCount, url, savePath, timeOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return DefaultDownload.download(url, savePath);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Downloader download(String serverPath, String savePath, int threadCount) {
        return Downloader.download(serverPath, savePath, threadCount, -1);
    }

    public static Downloader downloadToDir(String serverPath, String dirPath) {
        return Downloader.downloadToDir(serverPath, dirPath, -1, -1);
    }

    public static Downloader downloadToDir(String serverPath, String dirPath, int threadCount, int timeOut) {
        File file = Downloader.createFileForDownload(serverPath, dirPath, timeOut);
        return Downloader.download(serverPath, file.getAbsolutePath(), threadCount, timeOut);
    }

    public static File createFileForDownload(String url, String dir, int timeOut) {
        File _dir = new File(dir);
        if (_dir.isFile()) {
            throw new RuntimeException("The file download directory is not a folder");
        }
        try {
            _dir.mkdirs();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create file download directory", throwable);
        }
        String fileName = Downloader.getFileName(url, timeOut);
        int temp = fileName.lastIndexOf(".");
        String oName = fileName.substring(0, temp > 0 ? temp : fileName.length());
        String suffixName = temp > 0 ? fileName.substring(temp) : "";
        File file = new File(_dir, fileName);
        int x = 0;
        try {
            while (file.exists()) {
                file = new File(_dir, oName + " (" + ++x + ")" + suffixName);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create file download directory", throwable);
        }
        return file;
    }

    public static String getFileName(String url, int timeOut) {
        try {
            int x;
            String fileName;
            URL u = new URL(url);
            URLConnection conn = u.openConnection();
            if (timeOut > 0) {
                conn.setConnectTimeout(timeOut);
                conn.setReadTimeout(timeOut);
            }
            if ((fileName = conn.getHeaderField("Content-Disposition")) != null && (x = fileName.indexOf("filename=")) > 0) {
                int y = fileName.indexOf(";", x);
                if (y < 0) {
                    y = fileName.length();
                }
                fileName = fileName.substring(x + 9, y);
                return fileName;
            }
            int index = conn.getURL().toString().lastIndexOf("/");
            if (index == -1) {
                return conn.getURL().toString();
            }
            return conn.getURL().toString().substring(index + 1);
        }
        catch (Throwable u) {
            int index = url.lastIndexOf("/");
            if (index == -1) {
                return url;
            }
            return url.substring(index + 1);
        }
    }

    public static Downloader downloadToDir(String serverPath, String dirPath, int threadCount) throws IOException {
        return Downloader.downloadToDir(serverPath, dirPath, threadCount, -1);
    }

    protected void setSuccess() {
        if (this.status() == Status.Running || this.status() == Status.Pause) {
            this.status(Status.Success);
            this.data = new DownloadData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void error(Throwable cause) {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.running()) {
                return;
            }
            this.errorCause = cause;
            this.status(Status.Error);
        }
    }

    public final double progressPercent() {
        double progress = this.progress();
        if (progress >= 0.0) {
            return progress * 100.0;
        }
        return -1.0;
    }

    public final double progress() {
        if (this.totalSize() != null) {
            return (double)this.currentSize().size() * 1.0 / (double)this.totalSize().size();
        }
        return -1.0;
    }

    private final void update() {
        long time = System.currentTimeMillis();
        while (!this.time.isEmpty() && time - (Long)((Map.Entry)this.time.getFirst()).getKey() > 1000L) {
            this.speed -= ((Long)((Map.Entry)this.time.getFirst()).getValue()).longValue();
            this.time.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(Status status) {
        Downloader downloader = this;
        synchronized (downloader) {
            if (status != null && status != this.status()) {
                this.status = status;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status status() {
        Downloader downloader = this;
        synchronized (downloader) {
            return this.status;
        }
    }

    public final boolean hasError() {
        return this.status() == Status.Error;
    }

    public final boolean success() {
        return this.status() == Status.Success;
    }

    public final boolean pause() {
        return this.status() == Status.Pause;
    }

    public final Downloader cancel() {
        this.status(Status.Cancel);
        return this;
    }

    public final Downloader pause(boolean b) {
        this.status(b ? Status.Pause : Status.Running);
        return this;
    }

    public final Throwable errorCause() {
        return this.errorCause;
    }

    public final DownloadData data() {
        return this.data;
    }

    public final Date startTime() {
        return new Date(this.startTime);
    }

    public final DataSize totalSize() {
        if (this.totalSize > 0L) {
            return new DataSize(this.totalSize);
        }
        return null;
    }

    public final boolean running() {
        return this.status() == Status.Running;
    }

    public String file() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void add(long size) {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.running()) {
                return;
            }
            this.currentSize += size;
            long time = System.currentTimeMillis();
            this.speed += size;
            this.time.add(new AbstractMap.SimpleEntry<Long, Long>(time, size));
            this.update();
        }
    }

    public final DataSize currentSize() {
        return new DataSize(this.currentSize);
    }

    public final Time remainingTime() {
        if (this.waitSize() != null) {
            return new Time((long)((double)this.waitSize().size() / this.speed().rate(new DataRateUnit(DataSizeUnit.B, TimeUnit.ms))));
        }
        return null;
    }

    public final DataSize waitSize() {
        if (this.totalSize() != null) {
            return new DataSize(this.totalSize().size() - this.currentSize().size());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataRate speed() {
        Downloader downloader = this;
        synchronized (downloader) {
            this.update();
            return new DataRate(new DataSize(this.speed), TimeUnit.s);
        }
    }

    public boolean finish() {
        Status status = this.status();
        return status == Status.Success || status == Status.Cancel || status == Status.Error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downloader waitFinish() {
        while (true) {
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.finish()) {
                    break;
                }
                try {
                    this.wait();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public Downloader waitSuccess() throws IOException {
        this.waitFinish();
        if (this.success()) {
            return this;
        }
        if (this.hasError()) {
            if (this.errorCause instanceof IOException) {
                throw (IOException)this.errorCause;
            }
            throw new IOException(this.errorCause);
        }
        throw new IOException("Unknown error");
    }

    public static enum Status {
        Running,
        Success,
        Error,
        Cancel,
        Pause;

    }

    public static class DownloadData {
        private final Downloader downloader;
        private final long endTime;

        private DownloadData(Downloader x) {
            this.downloader = x;
            this.endTime = System.currentTimeMillis();
        }

        public Date startTime() {
            return this.downloader.startTime();
        }

        public DataSize currentSize() {
            return this.downloader.currentSize();
        }

        public DataRate averageSpeed() {
            return new DataRate(this.totalSize(), this.runTime());
        }

        public boolean error() {
            return this.downloader.hasError();
        }

        public Throwable errorCause() {
            return this.downloader.errorCause();
        }

        public Date endTime() {
            return new Date(this.endTime);
        }

        public DataSize totalSize() {
            return this.downloader.currentSize();
        }

        public Time runTime() {
            return new Time(this.endTime - this.downloader.startTime);
        }
    }
}

