/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.net.dowloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Objects;
import me.nullaqua.api.collection.FastLinkedList;
import me.nullaqua.api.net.dowloader.DefaultDownload;
import me.nullaqua.api.net.dowloader.Downloader;
import me.nullaqua.api.util.quantity.DataRate;
import me.nullaqua.api.util.quantity.DataSize;
import me.nullaqua.api.util.quantity.Time;
import me.nullaqua.api.util.quantity.unit.DataSizeUnit;
import me.nullaqua.api.util.quantity.unit.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MultiThreadDownload {
    private final String serverPath;
    private final String localPath;
    private MultiThreadDownloader downloader;

    public MultiThreadDownload(String serverPath, String localPath) {
        this.serverPath = serverPath;
        this.localPath = localPath;
    }

    public static MultiThreadDownloader download(int threadCount, String serverPath, String localPath) throws IOException {
        return MultiThreadDownload.download(threadCount, serverPath, localPath, -1);
    }

    public static MultiThreadDownloader download(int threadCount, String serverPath, String localPath, int timeOut) throws IOException {
        MultiThreadDownload downloader = new MultiThreadDownload(serverPath, localPath);
        long length = downloader.getLength(timeOut);
        if (length <= 0L) {
            throw new IOException("Could not get the length of the file");
        }
        downloader.downloader = new MultiThreadDownloader(threadCount, length, localPath);
        long startIndex = 0L;
        for (int threadId = 0; threadId < threadCount; ++threadId) {
            long blockSize = (length - startIndex) / (long)(threadCount - threadId);
            long endIndex = startIndex + blockSize - 1L;
            MultiThreadDownload multiThreadDownload = downloader;
            Objects.requireNonNull(multiThreadDownload);
            DownloadThread thread = multiThreadDownload.new DownloadThread(threadId, startIndex, endIndex, timeOut, blockSize);
            startIndex = endIndex + 1L;
            downloader.downloader.addThread(thread, threadId);
            thread.start();
        }
        return downloader.downloader;
    }

    private long getLength(int timeOut) throws IOException {
        URL url = new URL(this.serverPath);
        URLConnection conn = url.openConnection();
        if (timeOut > 0) {
            conn.setConnectTimeout(timeOut);
            conn.setReadTimeout(timeOut);
        }
        long length = conn.getContentLengthLong();
        RandomAccessFile raf = new RandomAccessFile(this.localPath, "rwd");
        raf.setLength(length);
        raf.close();
        return length;
    }

    public static class MultiThreadDownloader
    extends Downloader {
        private final DownloadThread[] threads;
        private final int totalThread;
        private int currentThread;

        private MultiThreadDownloader(int totalThread, long totalSize, String fileName) {
            super(totalSize, fileName);
            this.totalThread = totalThread;
            this.threads = new DownloadThread[totalThread];
            this.currentThread = totalThread;
        }

        public int totalThread() {
            return this.totalThread;
        }

        public int currentThread() {
            return this.currentThread;
        }

        @Deprecated
        public DataSize totalSize(int id) {
            return this.threads[id].totalSize();
        }

        @Deprecated
        public DataSize currentSize(int id) {
            return this.threads[id].currentSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(int threadId) {
            MultiThreadDownloader multiThreadDownloader = this;
            synchronized (multiThreadDownloader) {
                this.threads[threadId] = null;
                --this.currentThread;
                if (this.currentThread == 0) {
                    super.setSuccess();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addThread(DownloadThread thread, int threadId) {
            MultiThreadDownloader multiThreadDownloader = this;
            synchronized (multiThreadDownloader) {
                this.threads[threadId] = thread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _error(Throwable e) {
            MultiThreadDownloader multiThreadDownloader = this;
            synchronized (multiThreadDownloader) {
                super.error(e);
                for (DownloadThread thread : this.threads) {
                    if (thread == null) continue;
                    if (thread.conn != null) {
                        try {
                            thread.conn.getInputStream().close();
                            thread.conn.getOutputStream().close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    thread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public final double progressPercent(int id) {
            DownloadThread downloadThread = this.threads[id];
            synchronized (downloadThread) {
                return this.threads[id].progressPercent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public final double progress(int id) {
            DownloadThread downloadThread = this.threads[id];
            synchronized (downloadThread) {
                return this.threads[id].progress();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public final Time remainingTime(int id) {
            DownloadThread downloadThread = this.threads[id];
            synchronized (downloadThread) {
                return this.threads[id].remainingTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public final DataSize waitSize(int id) {
            DownloadThread downloadThread = this.threads[id];
            synchronized (downloadThread) {
                return this.threads[id].waitSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public DataRate speed(int id) {
            DownloadThread downloadThread = this.threads[id];
            synchronized (downloadThread) {
                return this.threads[id].speed();
            }
        }
    }

    private class DownloadThread
    extends Thread {
        private final long startIndex;
        private final long endIndex;
        private final int threadId;
        private final int timeOut;
        private final FastLinkedList<Map.Entry<Long, Long>> threadSpeedData = new FastLinkedList();
        private final long totalSize;
        private long currentSize = 0L;
        private long speed = 0L;
        private URLConnection conn;

        public DownloadThread(int threadId, long startIndex, long endIndex, int timeOut, long totalSize) {
            this.threadId = threadId;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.timeOut = timeOut;
            this.totalSize = totalSize;
        }

        private void add(long size) {
            this.currentSize += size;
            this.threadSpeedData.add(Map.entry(System.currentTimeMillis(), size));
            this.speed += size;
            MultiThreadDownload.this.downloader.add(size);
            this.update();
        }

        private void update() {
            long time = System.currentTimeMillis();
            while (!this.threadSpeedData.isEmpty() && time - (Long)((Map.Entry)this.threadSpeedData.getFirst()).getKey() > 1000L) {
                this.speed -= ((Long)((Map.Entry)this.threadSpeedData.getFirst()).getValue()).longValue();
                this.threadSpeedData.removeFirst();
            }
        }

        public DataRate speed() {
            return new DataRate(this.speed, DataSizeUnit.B, TimeUnit.s);
        }

        public DataSize currentSize() {
            return new DataSize(this.currentSize, DataSizeUnit.B);
        }

        public DataSize totalSize() {
            return new DataSize(this.totalSize, DataSizeUnit.B);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final double progressPercent() {
            DownloadThread downloadThread = this;
            synchronized (downloadThread) {
                return (double)this.currentSize / (double)this.totalSize * 100.0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final double progress() {
            DownloadThread downloadThread = this;
            synchronized (downloadThread) {
                return (double)this.currentSize / (double)this.totalSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Time remainingTime() {
            DownloadThread downloadThread = this;
            synchronized (downloadThread) {
                return new Time((double)this.waitSize().size() / this.speed().rate(DataSizeUnit.B, TimeUnit.s), TimeUnit.s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DataSize waitSize() {
            DownloadThread downloadThread = this;
            synchronized (downloadThread) {
                return new DataSize(this.totalSize - this.currentSize, DataSizeUnit.B);
            }
        }

        @Override
        public void run() {
            try (final RandomAccessFile raf = new RandomAccessFile(MultiThreadDownload.this.localPath, "rwd");){
                URL url = new URL(MultiThreadDownload.this.serverPath);
                this.conn = url.openConnection();
                this.conn.setRequestProperty("Range", "bytes=" + this.startIndex + "-" + this.endIndex);
                if (this.timeOut > 0) {
                    this.conn.setConnectTimeout(this.timeOut);
                    this.conn.setReadTimeout(this.timeOut);
                }
                InputStream is = this.conn.getInputStream();
                raf.seek(this.startIndex);
                DefaultDownload.copy(is, new OutputStream(){

                    @Override
                    public void write(byte @NotNull [] b) throws IOException {
                        raf.write(b);
                    }

                    @Override
                    public void write(byte @NotNull [] b, int off, int len) throws IOException {
                        raf.write(b, off, len);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        raf.write(b);
                    }
                }, this::add, MultiThreadDownload.this.downloader);
                if (MultiThreadDownload.this.downloader.status() == Downloader.Status.Cancel || MultiThreadDownload.this.downloader.status() == Downloader.Status.Error) {
                    raf.close();
                    new File(MultiThreadDownload.this.localPath).delete();
                }
            }
            catch (Throwable e) {
                MultiThreadDownload.this.downloader._error(e);
                return;
            }
            MultiThreadDownload.this.downloader.finish(this.threadId);
        }
    }
}

