/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.chat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.nullaqua.api.player.chat.RGBColor;
import org.bukkit.ChatColor;

public final class GradientColor {
    private static final Pattern gradient = Pattern.compile("#([0-9A-Fa-f]{6})-([0-9A-Fa-f]{6})<(.*?)>");
    private RGBColor start;
    private RGBColor end;

    public GradientColor(String start, String end) {
        this(new RGBColor(start), new RGBColor(end));
    }

    public GradientColor(RGBColor start, RGBColor end) {
        this.start = start;
        this.end = end;
    }

    public static String colorText(String start, String end, String message) {
        return GradientColor.colorText(new RGBColor(start), new RGBColor(end), message);
    }

    public static String colorText(RGBColor start, RGBColor end, String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int r = end.getRed() - start.getRed();
        int g = end.getGreen() - start.getGreen();
        int b = end.getBlue() - start.getBlue();
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        double len = ChatColor.stripColor((String)message).length() - 1;
        StringBuilder p = new StringBuilder();
        int j = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '\u00a7' && i != message.length() - 1) {
                ChatColor c = ChatColor.getByChar((char)message.charAt(i + 1));
                if (c == ChatColor.RESET) {
                    p = new StringBuilder();
                    ++i;
                    continue;
                }
                if (c != null) {
                    if (c.isFormat()) {
                        p.append(c);
                    }
                    ++i;
                    continue;
                }
            }
            double x = (double)j / len;
            RGBColor color = new RGBColor(start.getRed() + (int)((double)r * x), start.getGreen() + (int)((double)g * x), start.getBlue() + (int)((double)b * x));
            builder.append(color).append((CharSequence)p).append(message.charAt(i));
            ++j;
        }
        return builder.toString();
    }

    public static String setColor(String message) {
        message = RGBColor.setRandomColor(message);
        Matcher matcher = gradient.matcher(message);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(builder, GradientColor.setGradient(matcher));
        }
        matcher.appendTail(builder);
        return RGBColor.setColor(builder.toString());
    }

    private static String setGradient(Matcher matcher) {
        String s = matcher.group(1);
        String e = matcher.group(2);
        String message = matcher.group(3);
        RGBColor start = new RGBColor(Integer.parseInt(s, 16));
        RGBColor end = new RGBColor(Integer.parseInt(e, 16));
        return GradientColor.colorText(start, end, message);
    }

    public String colorText(String message) {
        return GradientColor.colorText(this.start, this.end, message);
    }

    public RGBColor getStart() {
        return this.start;
    }

    public GradientColor setStart(RGBColor start) {
        this.start = start;
        return this;
    }

    public RGBColor getEnd() {
        return this.end;
    }

    public GradientColor setEnd(RGBColor end) {
        this.end = end;
        return this;
    }
}

