/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.chat;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public final class RGBColor {
    private static final int MASK = 255;
    private static final Pattern hex = Pattern.compile("#([0-9A-Fa-f]{6})");
    private static final Pattern random = Pattern.compile("<random>");
    private static final Map<RGBColor, ChatColor> toChatColor = new HashMap<RGBColor, ChatColor>();
    private static final Map<net.md_5.bungee.api.ChatColor, RGBColor> fromChatColor = new HashMap<net.md_5.bungee.api.ChatColor, RGBColor>();
    private final int r;
    private final int g;
    private final int b;

    public RGBColor(int r, int g, int b) {
        this.r = r & 0xFF;
        this.g = g & 0xFF;
        this.b = b & 0xFF;
    }

    public RGBColor(ChatColor color) {
        this(fromChatColor.get(color.asBungee()).getColor());
    }

    public RGBColor(int color) {
        if (color < 0) {
            color = 0;
        }
        this.r = RGBColor.getRed(color) & 0xFF;
        this.g = RGBColor.getGreen(color) & 0xFF;
        this.b = RGBColor.getBlue(color) & 0xFF;
    }

    public int getColor() {
        return RGBColor.getColor(this.r, this.g, this.b);
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getColor(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public RGBColor(net.md_5.bungee.api.ChatColor chatColor) {
        this(fromChatColor.get(chatColor).getColor());
    }

    public RGBColor(org.bukkit.Color color) {
        if (color == null) {
            this.b = 0;
            this.g = 0;
            this.r = 0;
            return;
        }
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public RGBColor(Color color) {
        if (color == null) {
            this.b = 0;
            this.g = 0;
            this.r = 0;
            return;
        }
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public RGBColor(String color) {
        this(Integer.parseInt(color, 16));
    }

    public static String setColor(String message) {
        message = RGBColor.setRandomColor(message);
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = hex.matcher(message);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuilder, RGBColor.toColorCode(matcher.group()));
        }
        matcher.appendTail(stringBuilder);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)stringBuilder.toString());
    }

    public static String setRandomColor(String message) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = random.matcher(message);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuilder, RGBColor.random().getHexColor());
        }
        matcher.appendTail(stringBuilder);
        return stringBuilder.toString();
    }

    public static String toColorCode(String hexColor) {
        StringBuilder builder = new StringBuilder("\u00a7x");
        for (char i : hexColor.toCharArray()) {
            if ("0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(i) <= -1) continue;
            builder.append("\u00a7").append(i);
        }
        return builder.toString();
    }

    public String getHexColor() {
        return RGBColor.getHexColor(this.r, this.g, this.b);
    }

    public static RGBColor random() {
        return new RGBColor(new Random().nextInt(0xFFFFFF));
    }

    public static String getHexColor(int r, int g, int b) {
        return RGBColor.getHexColor(RGBColor.getColor(r, g, b));
    }

    public static String getHexColor(int color) {
        return RGBColor.getHexRed(color) + RGBColor.getHexGreen(color) + RGBColor.getHexBlue(color);
    }

    public static String getHexRed(int color) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(RGBColor.getRed(color)));
        if (builder.length() == 1) {
            builder.insert(0, '0');
        }
        return builder.toString();
    }

    public static String getHexGreen(int color) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(RGBColor.getGreen(color)));
        if (builder.length() == 1) {
            builder.insert(0, '0');
        }
        return builder.toString();
    }

    public static String getHexBlue(int color) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(RGBColor.getBlue(color)));
        if (builder.length() == 1) {
            builder.insert(0, '0');
        }
        return builder.toString();
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public String getHexRed() {
        return RGBColor.getHexRed(this.getColor());
    }

    public String getHexGreen() {
        return RGBColor.getHexGreen(this.getColor());
    }

    public String getHexBlue() {
        return RGBColor.getHexBlue(this.getColor());
    }

    public String toString() {
        return this.toColorCode();
    }

    public String toColorCode() {
        String[] p = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        int version = Integer.parseInt(p[p.length - 1].split("_")[1]);
        if (version >= 16) {
            return RGBColor.toColorCode(this.getHexColor());
        }
        RGBColor c = null;
        for (Map.Entry<RGBColor, ChatColor> entry : toChatColor.entrySet()) {
            if (this.getDifference(entry.getKey()) >= this.getDifference(c)) continue;
            c = entry.getKey();
        }
        return "" + toChatColor.get(c);
    }

    public int getDifference(RGBColor other) {
        if (other == null) {
            return 765;
        }
        return Math.abs(other.r - this.r) + Math.abs(other.g - this.g) + Math.abs(other.b - this.b);
    }

    static {
        toChatColor.put(new RGBColor(0), ChatColor.BLACK);
        toChatColor.put(new RGBColor(170), ChatColor.DARK_BLUE);
        toChatColor.put(new RGBColor(43520), ChatColor.DARK_GREEN);
        toChatColor.put(new RGBColor(43690), ChatColor.DARK_AQUA);
        toChatColor.put(new RGBColor(0xAA0000), ChatColor.DARK_RED);
        toChatColor.put(new RGBColor(0xAA00AA), ChatColor.DARK_PURPLE);
        toChatColor.put(new RGBColor(0xFFAA00), ChatColor.GOLD);
        toChatColor.put(new RGBColor(0xAAAAAA), ChatColor.GRAY);
        toChatColor.put(new RGBColor(0x555555), ChatColor.DARK_GRAY);
        toChatColor.put(new RGBColor(0x5555FF), ChatColor.BLUE);
        toChatColor.put(new RGBColor(0x55FF55), ChatColor.GREEN);
        toChatColor.put(new RGBColor(0x55FFFF), ChatColor.AQUA);
        toChatColor.put(new RGBColor(0xFF5555), ChatColor.RED);
        toChatColor.put(new RGBColor(0xFF55FF), ChatColor.LIGHT_PURPLE);
        toChatColor.put(new RGBColor(0xFFFF55), ChatColor.YELLOW);
        toChatColor.put(new RGBColor(0xFFFFFF), ChatColor.WHITE);
        for (Map.Entry<RGBColor, ChatColor> entry : toChatColor.entrySet()) {
            fromChatColor.put(entry.getValue().asBungee(), entry.getKey());
        }
    }
}

