/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.gui;

import java.util.function.BiConsumer;
import me.nullaqua.api.player.gui.Gui;
import me.nullaqua.api.player.gui.GuiBuilder;
import me.nullaqua.api.player.gui.GuiCloseAction;
import me.nullaqua.api.player.gui.GuiItem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class ChestGui
implements Gui<ChestGui> {
    private final Plugin plugin;
    private final GuiItem[][] items;
    private final Player player;
    private int size;
    private String title;
    private GuiItem emptyItem;
    private boolean prohibitAnyClick;
    private boolean preventClose;
    private BiConsumer<ChestGui, GuiCloseAction> onClose;
    private boolean isOpen = false;
    private Inventory inventory;
    private GuiListener listener;

    private ChestGui(Plugin plugin, int size, String title, Player player, GuiItem emptyItem, boolean prohibitAnyClick, boolean preventClose, BiConsumer<ChestGui, GuiCloseAction> onClose, GuiItem[][] items) {
        this.plugin = plugin;
        this.size = size;
        this.title = title;
        this.player = player;
        this.emptyItem = emptyItem;
        this.prohibitAnyClick = prohibitAnyClick;
        this.preventClose = preventClose;
        this.onClose = onClose;
        this.items = items;
        this.init();
        this.open();
    }

    private void init() {
        this.inventory = this.player.getServer().createInventory((InventoryHolder)this.player, this.size * 9, this.title);
        this.paint();
    }

    public void paint() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.items[i][j] == null) {
                    this.items[i][j] = this.emptyItem;
                }
                this.inventory.setItem(i * 9 + j, this.items[i][j].getItem());
            }
        }
    }

    public static Builder builder(Plugin plugin) {
        return new Builder(plugin);
    }

    public GuiItem getEmptyItem() {
        return this.emptyItem;
    }

    public void setEmptyItem(GuiItem emptyItem) {
        this.emptyItem = emptyItem;
    }

    public GuiItem getItem(int x, int y) {
        if (x >= 0 && x < this.size && y >= 0 && y < 9) {
            return this.items[x][y] != null ? this.items[x][y] : this.emptyItem;
        }
        return null;
    }

    public ChestGui clearItems() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.removeItem(i, j);
            }
        }
        return this;
    }

    public GuiItem removeItem(int x, int y) {
        return this.setItem(x, y, this.emptyItem);
    }

    public GuiItem setItem(int x, int y, GuiItem item) {
        if (x >= 0 && x < this.size && y >= 0 && y < 9) {
            GuiItem item1 = this.items[x][y];
            this.items[x][y] = item;
            return item1;
        }
        return null;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.isOpen) {
            this.close(true);
            this.init();
            this.open();
        } else {
            this.init();
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isProhibitAnyClick() {
        return this.prohibitAnyClick;
    }

    @Override
    public void setProhibitAnyClick(boolean b) {
        this.prohibitAnyClick = b;
    }

    @Override
    public boolean isPreventClose() {
        return this.preventClose;
    }

    @Override
    public void setPreventClose(boolean b) {
        this.preventClose = b;
    }

    @Override
    public BiConsumer<ChestGui, GuiCloseAction> getOnClose() {
        return this.onClose;
    }

    @Override
    public void setOnClose(BiConsumer<ChestGui, GuiCloseAction> onClose) {
        this.onClose = onClose;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Listener getGuiListener() {
        return this.listener;
    }

    @Override
    public void open() {
        if (!this.plugin.isEnabled() || this.isOpen) {
            return;
        }
        this.listener = new GuiListener();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        this.player.openInventory(this.inventory);
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.close(true);
            this.onClose.accept(this, GuiCloseAction.PLUGIN);
        }
    }

    protected void close(boolean send) {
        if (!this.isOpen) {
            return;
        }
        HandlerList.unregisterAll((Listener)this.listener);
        if (send) {
            this.player.closeInventory();
        }
        this.isOpen = false;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static class Builder
    implements GuiBuilder<ChestGui> {
        private final GuiItem[][] items = new GuiItem[6][9];
        private GuiItem emptyItem = GuiItem.EMPTY;
        private String title = "Gui";
        private int size = 6;
        private boolean prohibitAnyClick = false;
        private boolean preventClose = false;
        private Plugin plugin;
        private BiConsumer<ChestGui, GuiCloseAction> onClose = (chestGui, guiCloseAction) -> {};

        Builder(Plugin plugin) {
            this.plugin = plugin;
        }

        public GuiItem getEmptyItem() {
            return this.emptyItem;
        }

        public Builder emptyItem(GuiItem emptyItem) {
            if (emptyItem == null) {
                return this;
            }
            this.emptyItem = emptyItem;
            return this;
        }

        @Override
        public ChestGui make(Player player) {
            return new ChestGui(this.plugin, this.size, this.title, player, this.emptyItem, this.prohibitAnyClick, this.preventClose, this.onClose, this.items);
        }

        public Builder title(String title) {
            if (title == null) {
                return this;
            }
            this.title = title;
            return this;
        }

        @Override
        public String title() {
            return this.title;
        }

        public Builder prohibitAnyClick(boolean prohibitAnyClick) {
            this.prohibitAnyClick = prohibitAnyClick;
            return this;
        }

        @Override
        public boolean prohibitAnyClick() {
            return this.prohibitAnyClick;
        }

        public Builder preventClose(boolean preventClose) {
            this.preventClose = preventClose;
            return this;
        }

        @Override
        public boolean preventClose() {
            return this.preventClose;
        }

        public Builder plugin(Plugin plugin) {
            if (plugin == null) {
                return this;
            }
            this.plugin = plugin;
            return this;
        }

        @Override
        public Plugin plugin() {
            return this.plugin;
        }

        public Builder onClose(BiConsumer<ChestGui, GuiCloseAction> onClose) {
            if (onClose == null) {
                return this;
            }
            this.onClose = onClose;
            return this;
        }

        @Override
        public BiConsumer<ChestGui, GuiCloseAction> onClose() {
            return this.onClose;
        }

        public int getSize() {
            return this.size;
        }

        public Builder setSize(int size) {
            if (size <= 0 || size > 6) {
                return this;
            }
            this.size = size;
            return this;
        }
    }

    private class GuiListener
    implements Listener {
        private GuiListener() {
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().equals(ChestGui.this.plugin)) {
                ChestGui.this.close(true);
                ChestGui.this.onClose.accept(ChestGui.this, GuiCloseAction.FORCED);
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            if (event.getPlayer().equals(ChestGui.this.player)) {
                ChestGui.this.close(false);
                ChestGui.this.onClose.accept(ChestGui.this, GuiCloseAction.FORCED);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (!ChestGui.this.inventory.equals(event.getInventory())) {
                return;
            }
            if (ChestGui.this.preventClose) {
                ChestGui.this.player.openInventory(ChestGui.this.inventory);
            } else {
                ChestGui.this.close(false);
                ChestGui.this.onClose.accept(ChestGui.this, GuiCloseAction.PLAYER);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryClick(InventoryClickEvent event) {
            if (!ChestGui.this.inventory.equals(event.getInventory())) {
                return;
            }
            if (!ChestGui.this.inventory.equals(event.getClickedInventory())) {
                event.setCancelled(ChestGui.this.prohibitAnyClick || event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.COLLECT_TO_CURSOR);
                return;
            }
            event.setCancelled(true);
            int x = event.getSlot() / 9;
            int y = event.getSlot() % 9;
            GuiItem.Response response = ChestGui.this.items[x][y].getOnClick().apply(ChestGui.this, event.getClick());
            if (response.getInput() != null) {
                ChestGui.this.close(true);
                ChestGui.this.onClose.accept(ChestGui.this, GuiCloseAction.TEMPORARY);
                response.getInput().clone().preventClose(true).onClose(anvilInput -> ChestGui.this.open()).open(ChestGui.this.player);
                return;
            }
            if (response.getClose()) {
                ChestGui.this.close(true);
                ChestGui.this.onClose.accept(ChestGui.this, GuiCloseAction.PLUGIN);
            }
            if (response.getBuilder() != null) {
                response.getBuilder().open(ChestGui.this.player);
            }
        }
    }
}

