/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.gui;

import java.util.function.BiFunction;
import me.nullaqua.api.player.gui.Gui;
import me.nullaqua.api.player.gui.GuiBuilder;
import me.nullaqua.api.player.input.PlayerAnvilInput;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class GuiItem
implements Cloneable {
    public static final GuiItem EMPTY = new GuiItem(){
        {
            super.setOnClick((gui, type) -> Response.nothing());
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public GuiItem setItem(ItemStack item) {
            return this;
        }

        @Override
        public GuiItem setOnClick(BiFunction<Gui, ClickType, Response> onClick) {
            return this;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return "GuiItem{EMPTY}";
        }

        @Override
        public GuiItem clone() {
            return this;
        }
    };
    private ItemStack item = new ItemStack(Material.AIR);
    private BiFunction<Gui, ClickType, Response> onClick = (gui, type) -> Response.nothing();

    public ItemStack getItem() {
        return this.item;
    }

    public GuiItem setItem(ItemStack item) {
        this.item = item;
        return this;
    }

    public BiFunction<Gui, ClickType, Response> getOnClick() {
        return this.onClick;
    }

    public GuiItem setOnClick(BiFunction<Gui, ClickType, Response> onClick) {
        this.onClick = onClick;
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GuiItem) {
            return this.item.equals((Object)((GuiItem)obj).item) && this.onClick.equals(((GuiItem)obj).onClick);
        }
        return false;
    }

    public GuiItem clone() {
        try {
            GuiItem clone = (GuiItem)super.clone();
            clone.item = this.item.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "GuiItem { Item:" + this.item + ", OnClick:" + this.onClick + " }";
    }

    public static class Response {
        private final boolean close;
        private final GuiBuilder<?> builder;
        private final PlayerAnvilInput.Builder input;

        private Response(boolean close, GuiBuilder<?> builder, PlayerAnvilInput.Builder input) {
            this.close = close;
            this.builder = builder;
            this.input = input;
        }

        public static Response open(GuiBuilder<?> other) {
            return new Response(true, other, null);
        }

        public static Response input(PlayerAnvilInput.Builder input) {
            return new Response(false, null, input);
        }

        public static Response close() {
            return new Response(true, null, null);
        }

        public static Response nothing() {
            return new Response(false, null, null);
        }

        public boolean getClose() {
            return this.close;
        }

        public GuiBuilder<?> getBuilder() {
            return this.builder;
        }

        public PlayerAnvilInput.Builder getInput() {
            return this.input;
        }
    }
}

