/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import me.nullaqua.api.player.gui.ChestGui;
import me.nullaqua.api.player.gui.Gui;
import me.nullaqua.api.player.gui.GuiBuilder;
import me.nullaqua.api.player.gui.GuiCloseAction;
import me.nullaqua.api.player.gui.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PageGui
implements Gui<PageGui> {
    private final ChestGui chestGui;
    private final int maxPage;
    private final GuiItem bottomItem;
    private final GuiItem closeButton;
    private final GuiItem turnLeftButton;
    private final GuiItem turnRightButton;
    private final Map<Integer, GuiItem> items;
    private boolean prohibitAnyClick;
    private boolean preventClose;
    private BiConsumer<PageGui, GuiCloseAction> onClose;
    private int page;

    private PageGui(Plugin plugin, int size, String title, Player player, GuiItem emptyItem, ItemStack bottomItem, ItemStack closeButton, ItemStack turnLeftButton, ItemStack turnRightButton, Map<Integer, GuiItem> items, boolean prohibitAnyClick, boolean preventClose, BiConsumer<PageGui, GuiCloseAction> onClose) {
        this.chestGui = ((ChestGui.Builder)ChestGui.builder(plugin).setSize(size).title(title).emptyItem(emptyItem).prohibitAnyClick(prohibitAnyClick).preventClose(preventClose).onClose((chestGui1, guiCloseAction) -> this.getOnClose().accept(this, (GuiCloseAction)((Object)guiCloseAction)))).make(player);
        this.items = items;
        this.onClose = onClose;
        this.page = 0;
        this.bottomItem = new GuiItem().setItem(bottomItem);
        this.closeButton = new GuiItem().setItem(closeButton);
        this.closeButton.setOnClick((gui, clickType) -> GuiItem.Response.close());
        this.turnLeftButton = new GuiItem().setItem(turnLeftButton);
        this.turnLeftButton.setOnClick((gui, clickType) -> {
            this.setPage(this.page - 1);
            return GuiItem.Response.nothing();
        });
        this.turnRightButton = new GuiItem().setItem(turnRightButton);
        this.turnRightButton.setOnClick((gui, clickType) -> {
            this.setPage(this.page + 1);
            return GuiItem.Response.nothing();
        });
        Map.Entry<Integer, GuiItem> maxEntry = null;
        for (Map.Entry<Integer, GuiItem> entry : this.items.entrySet()) {
            if (maxEntry != null && entry.getKey() <= maxEntry.getKey()) continue;
            maxEntry = entry;
        }
        int maxPage1 = 0;
        if (maxEntry != null) {
            maxPage1 = (int)Math.ceil((double)((Integer)maxEntry.getKey()).intValue() / (double)((this.chestGui.getSize() - 1) * 9));
        }
        if (maxPage1 == 0) {
            maxPage1 = 1;
        }
        this.maxPage = maxPage1;
        this.paint();
    }

    public void paint() {
        this.setPage(this.page);
    }

    public int getSize() {
        return this.chestGui.getSize();
    }

    public static Builder builder(Plugin plugin) {
        return new Builder(plugin);
    }

    @Override
    public Plugin getPlugin() {
        return this.chestGui.getPlugin();
    }

    @Override
    public String getTitle() {
        return this.chestGui.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.chestGui.setTitle(title);
    }

    @Override
    public Player getPlayer() {
        return this.chestGui.getPlayer();
    }

    @Override
    public boolean isProhibitAnyClick() {
        return this.prohibitAnyClick;
    }

    @Override
    public void setProhibitAnyClick(boolean b) {
        this.prohibitAnyClick = b;
    }

    @Override
    public boolean isPreventClose() {
        return this.preventClose;
    }

    @Override
    public void setPreventClose(boolean b) {
        this.preventClose = b;
    }

    @Override
    public BiConsumer<PageGui, GuiCloseAction> getOnClose() {
        return this.onClose;
    }

    @Override
    public void setOnClose(BiConsumer<PageGui, GuiCloseAction> onClose) {
        this.onClose = onClose;
    }

    @Override
    public boolean isOpen() {
        return this.chestGui.isOpen();
    }

    @Override
    public Inventory getInventory() {
        return this.chestGui.getInventory();
    }

    @Override
    public Listener getGuiListener() {
        return this.chestGui.getGuiListener();
    }

    @Override
    public void open() {
        this.chestGui.open();
    }

    @Override
    public void close() {
        this.chestGui.close();
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public int getPage() {
        return this.page;
    }

    private void setPage(int page) {
        int i;
        if (page < 0) {
            page = 0;
        }
        if (page >= this.maxPage) {
            page = this.maxPage;
        }
        this.page = page;
        this.chestGui.clearItems();
        for (i = 0; i < 9; ++i) {
            this.chestGui.setItem(this.getSize() - 1, i, this.bottomItem);
        }
        for (i = 0; i < this.getSize() - 1; ++i) {
            for (int j = 0; j < 9; ++j) {
                int id = page * (this.getSize() - 1) * 9 + i * 9 + j;
                if (!this.items.containsKey(id)) continue;
                this.chestGui.setItem(i, j, this.items.get(id));
            }
        }
        if (!this.preventClose) {
            this.chestGui.setItem(this.getSize() - 1, 4, this.closeButton);
        }
        if (page > 0) {
            this.chestGui.setItem(this.getSize() - 1, 3, this.turnLeftButton);
        }
        if (page < this.maxPage - 1) {
            this.chestGui.setItem(this.getSize() - 1, 5, this.turnRightButton);
        }
        this.chestGui.paint();
    }

    public ItemStack getBottomItem() {
        return this.bottomItem.getItem();
    }

    public void setBottomItem(ItemStack bottomItem) {
        this.bottomItem.setItem(bottomItem);
    }

    public ItemStack getCloseButton() {
        return this.closeButton.getItem();
    }

    public void setCloseButton(ItemStack closeButton) {
        this.closeButton.setItem(closeButton);
    }

    public ItemStack getTurnLeftButton() {
        return this.turnLeftButton.getItem();
    }

    public void setTurnLeftButton(ItemStack turnLeftButton) {
        this.turnLeftButton.setItem(turnLeftButton);
    }

    public ItemStack getTurnRightButton() {
        return this.turnRightButton.getItem();
    }

    public void setTurnRightButton(ItemStack turnRightButton) {
        this.turnRightButton.setItem(turnRightButton);
    }

    public static class Builder
    implements GuiBuilder<PageGui> {
        private final Map<Integer, GuiItem> items = new HashMap<Integer, GuiItem>();
        private GuiItem emptyItem;
        private String title = "Chest";
        private int size = 6;
        private boolean prohibitAnyClick = false;
        private boolean preventClose = false;
        private ItemStack bottomItem;
        private ItemStack closeButton;
        private ItemStack turnLeft;
        private ItemStack turnRight;
        private Plugin plugin;
        private BiConsumer<PageGui, GuiCloseAction> onClose;

        private Builder(Plugin plugin) {
            try {
                this.bottomItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                this.closeButton = new ItemStack(Material.RED_STAINED_GLASS_PANE);
                this.turnLeft = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
                this.turnRight = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
            }
            catch (Exception e) {
                this.bottomItem = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)"STAINED_GLASS_PANE")), 1, 15);
                this.closeButton = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)"STAINED_GLASS_PANE")), 1, 14);
                this.turnLeft = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)"STAINED_GLASS_PANE")), 1, 13);
                this.turnRight = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)"STAINED_GLASS_PANE")), 1, 13);
            }
            this.emptyItem = GuiItem.EMPTY;
            this.onClose = (gui, b) -> {};
            ItemMeta meta = this.bottomItem.getItemMeta();
            assert (meta != null);
            meta.setDisplayName(" ");
            this.bottomItem.setItemMeta(meta);
            meta = this.closeButton.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u70b9\u51fb\u5173\u95ed");
            this.closeButton.setItemMeta(meta);
            meta = this.turnLeft.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u4e0a\u4e00\u9875");
            this.turnLeft.setItemMeta(meta);
            meta = this.turnRight.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u4e0b\u4e00\u9875");
            this.turnRight.setItemMeta(meta);
            this.plugin(plugin);
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder bottomItem(ItemStack bottomItem) {
            this.bottomItem = bottomItem;
            return this;
        }

        public Builder closeItem(ItemStack closeItem) {
            this.closeButton = closeItem;
            return this;
        }

        public Builder turnLeft(ItemStack turnLeft) {
            this.turnLeft = turnLeft;
            return this;
        }

        public Builder turnRight(ItemStack turnRight) {
            this.turnRight = turnRight;
            return this;
        }

        public Builder item(int index, GuiItem item) {
            this.items.put(index, item);
            return this;
        }

        public Map<Integer, GuiItem> items() {
            return this.items;
        }

        public Builder emptyItem(GuiItem item) {
            this.emptyItem = item;
            return this;
        }

        @Override
        public PageGui make(Player player) {
            return new PageGui(this.plugin, this.size, this.title, player, this.emptyItem, this.bottomItem, this.closeButton, this.turnLeft, this.turnRight, this.items, this.prohibitAnyClick, this.preventClose, this.onClose);
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public String title() {
            return this.title;
        }

        public Builder prohibitAnyClick(boolean prohibitAnyClick) {
            this.prohibitAnyClick = prohibitAnyClick;
            return this;
        }

        @Override
        public boolean prohibitAnyClick() {
            return this.prohibitAnyClick;
        }

        public Builder preventClose(boolean preventClose) {
            this.preventClose = preventClose;
            return this;
        }

        @Override
        public boolean preventClose() {
            return this.preventClose;
        }

        public Builder plugin(Plugin plugin) {
            this.plugin = plugin;
            return this;
        }

        @Override
        public Plugin plugin() {
            return this.plugin;
        }

        public Builder onClose(BiConsumer<PageGui, GuiCloseAction> onClose) {
            this.onClose = onClose;
            return this;
        }

        @Override
        public BiConsumer<PageGui, GuiCloseAction> onClose() {
            return this.onClose;
        }

        public Builder clone() {
            Builder clone = new Builder(this.plugin);
            clone.title = this.title;
            clone.size = this.size;
            clone.bottomItem = this.bottomItem.clone();
            clone.closeButton = this.closeButton.clone();
            clone.turnLeft = this.turnLeft.clone();
            clone.turnRight = this.turnRight.clone();
            clone.plugin = this.plugin;
            for (Map.Entry<Integer, GuiItem> entry : this.items.entrySet()) {
                clone.items.put(entry.getKey(), entry.getValue().clone());
            }
            return clone;
        }
    }
}

