/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.player.input;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerChatInput<T> {
    private static final List<UUID> players = new ArrayList<UUID>();
    private final EnumMap<EndReason, PlayerChatInput<?>> chainAfter;
    private final BiFunction<Player, String, Boolean> onInvalidInput;
    private final BiFunction<Player, String, Boolean> isValidInput;
    private final BiFunction<Player, String, T> setValue;
    private final BiConsumer<Player, T> onFinish;
    private final Consumer<Player> onCancel;
    private final Consumer<Player> onExpire;
    private final Runnable onDisconnect;
    private final Player player;
    private final String invalidInputMessgae;
    private final String sendValueMessage;
    private final String onExpireMessage;
    private final String cancel;
    private final Plugin main;
    private final int expiresAfter;
    private final InputListener listener = new InputListener();
    private boolean started;
    private final boolean repeat;
    private T value;
    private BukkitTask task;
    private EndReason end;

    private PlayerChatInput(@NotNull Plugin plugin, @NotNull Player player, @Nullable T startOn, @Nullable String invalidInputMessgae, @Nullable String sendValueMessage, @NotNull BiFunction<Player, String, Boolean> isValidInput, @NotNull BiFunction<Player, String, T> setValue, @NotNull BiConsumer<Player, T> onFinish, @NotNull Consumer<Player> onCancel, @NotNull String cancel, @NotNull BiFunction<Player, String, Boolean> onInvalidInput, boolean repeat, @Nullable EnumMap<EndReason, PlayerChatInput<?>> chainAfter, int expiresAfter, @NotNull Consumer<Player> onExpire, @Nullable String whenExpireMessage, @NotNull Runnable onDisconnect) {
        Objects.requireNonNull(plugin, "main can't be null");
        Objects.requireNonNull(player, "player can't be null");
        Objects.requireNonNull(invalidInputMessgae, "isValidInput can't be null");
        Objects.requireNonNull(sendValueMessage, "isValidInput can't be null");
        Objects.requireNonNull(isValidInput, "isValidInput can't be null");
        Objects.requireNonNull(setValue, "setValue can't be null");
        Objects.requireNonNull(onFinish, "onFinish can't be null");
        Objects.requireNonNull(onFinish, "onCancel can't be null");
        Objects.requireNonNull(onInvalidInput, "onInvalidInput can't be null");
        Objects.requireNonNull(cancel, "cancel can't be null");
        Objects.requireNonNull(onExpire, "onExpire can't be null");
        Objects.requireNonNull(onDisconnect, "onDisconnect can't be null");
        this.main = plugin;
        this.player = player;
        this.invalidInputMessgae = invalidInputMessgae;
        this.sendValueMessage = sendValueMessage;
        this.isValidInput = isValidInput;
        this.setValue = setValue;
        this.onFinish = onFinish;
        this.onCancel = onCancel;
        this.cancel = cancel;
        this.onInvalidInput = onInvalidInput;
        this.value = startOn;
        this.repeat = repeat;
        this.chainAfter = chainAfter;
        this.expiresAfter = expiresAfter;
        this.onExpire = onExpire;
        this.onExpireMessage = whenExpireMessage;
        this.onDisconnect = onDisconnect;
        this.start();
    }

    public static <U> Builder<U> builder() {
        return new Builder();
    }

    private static void addPlayer(UUID player) {
        players.add(player);
    }

    private static void removePlayer(UUID player) {
        players.remove(player);
    }

    public static boolean isInputing(UUID player) {
        return players.contains(player);
    }

    private void runEventOnMainThread(String message) {
        if (message.equalsIgnoreCase(this.cancel)) {
            this.onCancel.accept(this.player);
            this.end(EndReason.PLAYER_CANCELLS);
            return;
        }
        if (this.isValidInput.apply(this.player, message).booleanValue()) {
            this.value = this.setValue.apply(this.player, message);
            this.onFinish.accept(this.player, (Player)this.value);
            this.end(EndReason.FINISH);
        } else {
            if (this.onInvalidInput.apply(this.player, message).booleanValue()) {
                if (this.invalidInputMessgae != null) {
                    this.player.sendMessage(this.invalidInputMessgae);
                }
                if (this.sendValueMessage != null && this.repeat) {
                    this.player.sendMessage(this.sendValueMessage);
                }
            }
            if (!this.repeat) {
                this.onExpire.accept(this.player);
                this.end(EndReason.INVALID_INPUT);
            }
        }
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    private void start() {
        if (PlayerChatInput.isInputing(this.player.getUniqueId())) {
            throw new IllegalAccessError("Can't ask for input to a player that is already inputing");
        }
        PlayerChatInput.addPlayer(this.player.getUniqueId());
        this.main.getServer().getPluginManager().registerEvents((Listener)this.listener, this.main);
        if (this.expiresAfter > 0) {
            this.task = Bukkit.getScheduler().runTaskLater(this.main, () -> {
                if (!this.isStarted()) {
                    return;
                }
                this.onExpire.accept(this.player);
                if (this.onExpireMessage != null) {
                    this.player.sendMessage(this.onExpireMessage);
                }
                this.end(EndReason.RUN_OUT_OF_TIME);
            }, (long)this.expiresAfter);
        }
        if (this.sendValueMessage != null) {
            this.player.sendMessage(this.sendValueMessage);
        }
        this.started = true;
        this.end = null;
    }

    private void unregister() {
        if (this.task != null) {
            this.task.cancel();
        }
        PlayerChatInput.removePlayer(this.player.getUniqueId());
        HandlerList.unregisterAll((Listener)this.listener);
    }

    public void end(EndReason reason) {
        this.started = false;
        this.end = reason;
        this.unregister();
        if (this.chainAfter != null && this.chainAfter.get((Object)this.end) != null) {
            super.start();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private class InputListener
    implements Listener {
        private InputListener() {
        }

        @EventHandler
        public void onPlayerDisconnect(PlayerQuitEvent e) {
            if (e.getPlayer().getUniqueId().equals(PlayerChatInput.this.player.getUniqueId())) {
                if (!PlayerChatInput.this.isStarted()) {
                    return;
                }
                PlayerChatInput.this.onDisconnect.run();
                PlayerChatInput.this.end(EndReason.PLAYER_DISCONECTS);
            }
        }

        @EventHandler
        public void onPlayerChatEvent(AsyncPlayerChatEvent e) {
            if (!PlayerChatInput.this.player.getUniqueId().equals(e.getPlayer().getUniqueId())) {
                return;
            }
            if (!PlayerChatInput.this.isStarted()) {
                return;
            }
            e.setCancelled(true);
            Bukkit.getScheduler().runTask(PlayerChatInput.this.main, () -> PlayerChatInput.this.runEventOnMainThread(e.getMessage()));
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin() == PlayerChatInput.this.main) {
                PlayerChatInput.this.end(EndReason.CUSTOM);
            }
        }
    }

    public static class Builder<U> {
        private EnumMap<EndReason, PlayerChatInput<?>> chainAfter;
        private BiFunction<Player, String, Boolean> onInvalidInput = (p, mes) -> true;
        private BiFunction<Player, String, Boolean> isValidInput = (p, mes) -> true;
        private BiFunction<Player, String, U> setValue = (p, mes) -> this.value;
        private BiConsumer<Player, U> onFinish = (p, val) -> {};
        private Consumer<Player> onCancel = p -> {};
        private Consumer<Player> onExpire = p -> {};
        private Runnable onDisconnect = () -> {};
        private String invalidInputMessage = "That is not a valid input";
        private String sendValueMessage = "Send in the chat the value";
        private String whenExpire = "You ran out of time to answer";
        private String cancel = "cancel";
        private U value;
        private int expiresAfter = -1;
        private boolean repeat = true;
        private Plugin plugin;

        private Builder() {
        }

        public Builder<U> plugin(@NotNull Plugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public Builder<U> onInvalidInput(@NotNull BiFunction<Player, String, Boolean> onInvalidInput) {
            this.onInvalidInput = onInvalidInput;
            return this;
        }

        public Builder<U> isValidInput(@NotNull BiFunction<Player, String, Boolean> isValidInput) {
            this.isValidInput = isValidInput;
            return this;
        }

        public Builder<U> setValue(@NotNull BiFunction<Player, String, U> setValue) {
            this.setValue = setValue;
            return this;
        }

        public Builder<U> onFinish(@NotNull BiConsumer<Player, U> onFinish) {
            this.onFinish = onFinish;
            return this;
        }

        public Builder<U> onCancel(@NotNull Consumer<Player> onCancel) {
            this.onCancel = onCancel;
            return this;
        }

        public Builder<U> invalidInputMessage(@Nullable String invalidInputMessage) {
            this.invalidInputMessage = invalidInputMessage;
            return this;
        }

        public Builder<U> sendValueMessage(@Nullable String sendValueMessage) {
            this.sendValueMessage = sendValueMessage;
            return this;
        }

        public Builder<U> toCancel(@NotNull String cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder<U> defaultValue(@Nullable U def) {
            this.value = def;
            return this;
        }

        public Builder<U> repeat(boolean repeat) {
            this.repeat = repeat;
            return this;
        }

        public Builder<U> chainAfter(@NotNull PlayerChatInput<?> toChain, EndReason ... after) {
            if (this.chainAfter == null) {
                this.chainAfter = new EnumMap(EndReason.class);
            }
            for (EndReason cm : after) {
                if (cm == EndReason.PLAYER_DISCONECTS) continue;
                this.chainAfter.put(cm, toChain);
            }
            return this;
        }

        public Builder<U> onExpire(@NotNull Consumer<Player> onExpire) {
            this.onExpire = onExpire;
            return this;
        }

        public Builder<U> onExpireMessage(@Nullable String message) {
            this.whenExpire = message;
            return this;
        }

        public Builder<U> expiresAfter(int ticks) {
            if (ticks > 0) {
                this.expiresAfter = ticks;
            }
            return this;
        }

        public Builder<U> onPlayerDiconnect(@NotNull Runnable onDisconnect) {
            this.onDisconnect = onDisconnect;
            return this;
        }

        public PlayerChatInput<U> open(@NotNull Player player) {
            Validate.notNull((Object)this.plugin, (String)"Plugin cannot be null");
            Validate.notNull((Object)player, (String)"Player cannot be null");
            return new PlayerChatInput(this.plugin, player, this.value, this.invalidInputMessage, this.sendValueMessage, this.isValidInput, this.setValue, this.onFinish, this.onCancel, this.cancel, this.onInvalidInput, this.repeat, this.chainAfter, this.expiresAfter, this.onExpire, this.whenExpire, this.onDisconnect);
        }
    }

    public static enum EndReason {
        PLAYER_CANCELLS,
        FINISH,
        RUN_OUT_OF_TIME,
        PLAYER_DISCONECTS,
        INVALID_INPUT,
        CUSTOM;

    }
}

