/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.reflect;

import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import me.nullaqua.api.reflect.MethodAccessor;
import me.nullaqua.api.reflect.URLClassLoaderAccessor;

public class ClassLoaderAccessor {
    private static final MethodAccessor addClass = MethodAccessor.getMethod(ClassLoader.class, "addClass", Class.class);
    private static final MethodAccessor defineClass = MethodAccessor.getMethod(ClassLoader.class, "defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
    private static final MethodAccessor defineClass2 = MethodAccessor.getMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
    private static final MethodAccessor defineClass3 = MethodAccessor.getMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
    private static final MethodAccessor defineClass4 = MethodAccessor.getMethod(ClassLoader.class, "defineClass", String.class, ByteBuffer.class, ProtectionDomain.class);
    private final ClassLoader classLoader;

    public ClassLoaderAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassLoaderAccessor of(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return new URLClassLoaderAccessor((URLClassLoader)classLoader);
        }
        return new ClassLoaderAccessor(classLoader);
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void addClass(Class<?> clazz) throws Throwable {
        addClass.invoke(this.classLoader, clazz);
    }

    public Class<?> defineClass(byte[] bytes, int offset, int length) throws Throwable {
        return (Class)defineClass.invoke(this.classLoader, bytes, offset, length);
    }

    public Class<?> defineClass(String name, byte[] bytes, int offset, int length) throws Throwable {
        return (Class)defineClass2.invoke(this.classLoader, name, bytes, offset, length);
    }

    public Class<?> defineClass(String name, byte[] bytes, int offset, int length, ProtectionDomain protectionDomain) throws Throwable {
        return (Class)defineClass3.invoke(this.classLoader, name, bytes, offset, length, protectionDomain);
    }

    public Class<?> defineClass(String name, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws Throwable {
        return (Class)defineClass4.invoke(this.classLoader, name, byteBuffer, protectionDomain);
    }
}

