/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Objects;
import me.nullaqua.api.reflect.ReflectionAccessor;

public class ConstructorAccessor<T> {
    private final Constructor<T> constructor;
    private final MethodHandle constructorAccessor;

    public ConstructorAccessor(Constructor<T> constructor) {
        MethodType methodType;
        MethodHandle target;
        Objects.requireNonNull(constructor);
        ReflectionAccessor.checkVisibility(constructor.getDeclaringClass());
        try {
            MethodHandle unreflected = ReflectionAccessor.LOOKUP.unreflectConstructor(constructor);
            target = unreflected.asFixedArity();
            int paramCount = unreflected.type().parameterCount();
            methodType = MethodType.genericMethodType(0, true);
            target = target.asSpreader(Object[].class, paramCount);
        }
        catch (Exception e) {
            this.constructor = constructor;
            this.constructorAccessor = null;
            return;
        }
        this.constructor = constructor;
        this.constructorAccessor = target.asType(methodType);
    }

    public static <T> ConstructorAccessor<T> getConstructor(Class<T> c, Class<?> ... classes) {
        if (c == null) {
            return null;
        }
        classes = classes == null ? new Class[]{} : classes;
        try {
            return new ConstructorAccessor<T>(c.getConstructor(classes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> ConstructorAccessor<T> getDeclaredConstructor(Class<T> c, Class<?> ... classes) {
        if (c == null) {
            return null;
        }
        classes = classes == null ? new Class[]{} : classes;
        try {
            return new ConstructorAccessor<T>(c.getDeclaredConstructor(classes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public T invoke(Object ... args) throws Throwable {
        if (this.constructorAccessor == null) {
            ReflectionAccessor.checkVisibility(this.constructor.getDeclaringClass());
            this.constructor.setAccessible(true);
            T o = this.constructor.newInstance(args);
            this.constructor.setAccessible(false);
            return o;
        }
        return (T)this.constructorAccessor.invokeExact(args);
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }
}

