/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import me.nullaqua.api.reflect.ReflectionAccessor;

public final class FieldAccessor {
    private final Field field;
    private final boolean staticField;
    private final MethodHandle setter;
    private final MethodHandle getter;

    public static List<FieldAccessor> getDeclaredFields(Object o) {
        if (o == null) {
            return new ArrayList<FieldAccessor>();
        }
        return FieldAccessor.getDeclaredFields(o.getClass());
    }

    public FieldAccessor(Field field) {
        if (field == null) {
            this.field = null;
            this.setter = null;
            this.getter = null;
            this.staticField = false;
            return;
        }
        boolean staticField = Modifier.isStatic(field.getModifiers());
        MethodHandle getter = null;
        MethodHandle setter = null;
        if (field.getDeclaringClass().getPackage().equals(this.getClass().getPackage())) {
            this.field = field;
            this.setter = null;
            this.getter = null;
            this.staticField = staticField;
            return;
        }
        try {
            if (staticField) {
                getter = ReflectionAccessor.LOOKUP.findStaticGetter(field.getDeclaringClass(), field.getName(), field.getType());
                setter = ReflectionAccessor.LOOKUP.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType());
            } else {
                getter = ReflectionAccessor.LOOKUP.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
                setter = ReflectionAccessor.LOOKUP.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            if (staticField) {
                getter = getter.asType(ReflectionAccessor.STATIC_FIELD_GETTER);
                setter = setter.asType(ReflectionAccessor.STATIC_FIELD_SETTER);
            } else {
                getter = getter.asType(ReflectionAccessor.VIRTUAL_FIELD_GETTER);
                setter = setter.asType(ReflectionAccessor.VIRTUAL_FIELD_SETTER);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field = field;
        this.staticField = staticField;
        this.getter = getter;
        this.setter = setter;
    }

    public static FieldAccessor getField(Class<?> c, String field) {
        if (c == null || field == null) {
            return null;
        }
        try {
            return new FieldAccessor(c.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static FieldAccessor getDeclaredField(Class<?> c, String field) {
        if (c == null || field == null) {
            return null;
        }
        for (Class<?> clazz : ReflectionAccessor.getAllSuperClass(c)) {
            try {
                return new FieldAccessor(clazz.getDeclaredField(field));
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static List<FieldAccessor> getDeclaredFields(Class<?> type) {
        ArrayList<FieldAccessor> fields = new ArrayList<FieldAccessor>();
        for (Class<?> c : ReflectionAccessor.getAllSuperClass(type)) {
            fields.addAll(FieldAccessor.getFields(c));
        }
        return fields;
    }

    public static List<FieldAccessor> getFields(Object o) {
        if (o == null) {
            return new ArrayList<FieldAccessor>();
        }
        return FieldAccessor.getFields(o.getClass());
    }

    public static List<FieldAccessor> getFields(Class<?> type) {
        ArrayList<FieldAccessor> fields = new ArrayList<FieldAccessor>();
        List.of(type.getDeclaredFields()).forEach(field -> fields.add(new FieldAccessor((Field)field)));
        return fields;
    }

    public String toString() {
        return "FieldAccessor{" + this.field + "}";
    }

    public Field getField() {
        return this.field;
    }

    public boolean isStaticField() {
        return this.staticField;
    }

    public Object get(Object instance) throws Throwable {
        if (this.getter == null) {
            ReflectionAccessor.checkVisibility(this.field.getDeclaringClass());
            this.field.setAccessible(true);
            Object o = this.field.get(instance);
            this.field.setAccessible(false);
            return o;
        }
        if (this.staticField) {
            return this.getter.invokeExact();
        }
        return this.getter.invokeExact(instance);
    }

    public void set(Object instance, Object value) throws Throwable {
        if (this.setter == null) {
            ReflectionAccessor.checkVisibility(this.field.getDeclaringClass());
            this.field.setAccessible(true);
            this.field.set(instance, value);
            this.field.setAccessible(false);
            return;
        }
        if (this.staticField) {
            this.setter.invokeExact(value);
        } else {
            this.setter.invokeExact(instance, value);
        }
    }
}

