/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.nullaqua.api.reflect.CallerSensitive;
import me.nullaqua.api.reflect.FieldAccessor;
import me.nullaqua.api.reflect.MethodAccessor;
import sun.misc.Unsafe;

public final class ReflectionAccessor {
    static final MethodHandles.Lookup LOOKUP;
    static final Unsafe UNSAFE;
    static final MethodType STATIC_FIELD_GETTER;
    static final MethodType STATIC_FIELD_SETTER;
    static final MethodType VIRTUAL_FIELD_GETTER;
    static final MethodType VIRTUAL_FIELD_SETTER;
    static final StackWalker walker;

    private ReflectionAccessor() {
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void checkVisibility(Class<?> clazz) {
        if (clazz.getPackage().equals(ReflectionAccessor.class.getPackage())) {
            throw new UnsupportedOperationException("This class cannot be accessed");
        }
    }

    public static <T> T blankInstance(Class<T> type) throws Throwable {
        return (T)UNSAFE.allocateInstance(type);
    }

    public static Void voidInstance() throws Throwable {
        return ReflectionAccessor.blankInstance(Void.class);
    }

    public static MethodAccessor getMethodFromStackFrame(StackWalker.StackFrame stackFrame) {
        if (stackFrame == null) {
            return null;
        }
        return MethodAccessor.getMethod(stackFrame.getDeclaringClass(), stackFrame.getMethodName(), stackFrame.getMethodType().parameterArray());
    }

    @CallerSensitive
    public static StackWalker.StackFrame getCaller() {
        return walker.walk(frames -> frames.filter(m -> {
            MethodAccessor mthd = ReflectionAccessor.getMethodFromStackFrame(m);
            if (mthd == null) {
                return false;
            }
            return !mthd.getMethod().isAnnotationPresent(CallerSensitive.class);
        }).findFirst()).orElse(null);
    }

    @CallerSensitive
    public static MethodAccessor getCallerMethod() {
        return ReflectionAccessor.getMethodFromStackFrame(ReflectionAccessor.getCaller());
    }

    @CallerSensitive
    public static Class<?> getCallerClass() {
        StackWalker.StackFrame caller = ReflectionAccessor.getCaller();
        if (caller != null) {
            return caller.getDeclaringClass();
        }
        return null;
    }

    public static List<Class<?>> getAllSuperClass(Class<?> type) {
        ArrayList clazz = new ArrayList();
        if (type == null) {
            return clazz;
        }
        while (type != null && type != Object.class) {
            clazz.add(type);
            type = type.getSuperclass();
        }
        return clazz;
    }

    public static Class<?> getBothSuperClass(Class<?> a, Class<?> b) {
        if (a == null || b == null) {
            return Object.class;
        }
        List<Class<?>> aSuperClass = ReflectionAccessor.getAllSuperClass(a);
        List<Class<?>> bSuperClass = ReflectionAccessor.getAllSuperClass(b);
        for (Class<?> c : aSuperClass) {
            if (!bSuperClass.contains(c)) continue;
            return c;
        }
        return Object.class;
    }

    public static List<FieldAccessor> getFields(Class<?> c) {
        ArrayList<FieldAccessor> accessors = new ArrayList<FieldAccessor>();
        Arrays.asList(c.getDeclaredFields()).forEach(field -> accessors.add(new FieldAccessor((Field)field)));
        return accessors;
    }

    public static List<FieldAccessor> getDeclaredFields(Class<?> c) {
        ArrayList<FieldAccessor> accessors = new ArrayList<FieldAccessor>();
        for (Class<?> cc : ReflectionAccessor.getAllSuperClass(c)) {
            accessors.addAll(ReflectionAccessor.getFields(cc));
        }
        return accessors;
    }

    private static List<FieldAccessor> getBothFields(Object a, Object b) {
        if (a == null || b == null) {
            return new ArrayList<FieldAccessor>();
        }
        return ReflectionAccessor.getBothFields(a.getClass(), b.getClass());
    }

    private static List<FieldAccessor> getBothFields(Class<?> a, Class<?> b) {
        return FieldAccessor.getDeclaredFields(ReflectionAccessor.getBothSuperClass(a, b));
    }

    public static boolean isSimpleObject(Object o) {
        Class<?> type = o.getClass();
        return type.isPrimitive() || type.equals(String.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Character.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(Void.class) || type.equals(Byte.class) || type.isEnum() || type == Class.class || type == Method.class || type == Constructor.class;
    }

    public static <T> T cloneObject(T o) throws Throwable {
        if (null == o) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        return ReflectionAccessor.cloneObject(o, map);
    }

    private static <T> T cloneObject(T o, Map<Object, Object> map) throws Throwable {
        if (o == null) {
            return null;
        }
        if (ReflectionAccessor.isSimpleObject(o)) {
            return o;
        }
        Object newInstance = map.get(o);
        if (newInstance != null) {
            return (T)newInstance;
        }
        newInstance = o.getClass().isArray() ? ReflectionAccessor.cloneArray(o, map) : ReflectionAccessor.blankInstance(o.getClass());
        map.put(o, newInstance);
        ReflectionAccessor.cloneFields(o, newInstance, map);
        return (T)newInstance;
    }

    private static Object cloneArray(Object o, Map<Object, Object> map) throws Throwable {
        if (null == o) {
            return null;
        }
        if (!o.getClass().isArray()) {
            return ReflectionAccessor.cloneObject(o, map);
        }
        int len = Array.getLength(o);
        Object array = Array.newInstance(o.getClass().getComponentType(), len);
        map.put(o, array);
        for (int i = 0; i < len; ++i) {
            if (Array.get(o, i) == null) continue;
            Object x = ReflectionAccessor.cloneObject(Array.get(o, i), map);
            Array.set(array, i, x);
        }
        return array;
    }

    private static void cloneFields(Object object, Object newObject, Map<Object, Object> map) throws Throwable {
        if (object == null || newObject == null) {
            return;
        }
        List<FieldAccessor> fields = ReflectionAccessor.getDeclaredFields(object.getClass());
        for (FieldAccessor f : fields) {
            if (Modifier.isStatic(f.getField().getModifiers())) continue;
            f.set(newObject, ReflectionAccessor.cloneObject(f.get(object), map));
        }
    }

    public static <T> T objectCopy(T o, T newObject) throws Throwable {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(o, newObject);
        ReflectionAccessor.cloneFields(o, newObject, map);
        return o;
    }

    static {
        MethodHandles.Lookup lookup;
        Unsafe unsafe;
        STATIC_FIELD_GETTER = MethodType.methodType(Object.class);
        STATIC_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class);
        VIRTUAL_FIELD_GETTER = MethodType.methodType(Object.class, Object.class);
        VIRTUAL_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
            Field trustedLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = unsafe.staticFieldOffset(trustedLookup);
            Object baseValue = unsafe.staticFieldBase(trustedLookup);
            lookup = (MethodHandles.Lookup)unsafe.getObject(baseValue, offset);
        }
        catch (Exception e) {
            lookup = MethodHandles.lookup();
            unsafe = null;
        }
        UNSAFE = unsafe;
        LOOKUP = lookup;
    }
}

