/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.reflect;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import me.nullaqua.api.reflect.ClassLoaderAccessor;
import me.nullaqua.api.reflect.MethodAccessor;

public class URLClassLoaderAccessor
extends ClassLoaderAccessor {
    private static final MethodAccessor addURL = MethodAccessor.getMethod(URLClassLoader.class, "addURL", URL.class);

    public URLClassLoaderAccessor(URLClassLoader classLoader) {
        super(classLoader);
    }

    public static URLClassLoaderAccessor of(URLClassLoader classLoader) {
        return new URLClassLoaderAccessor(classLoader);
    }

    public URLClassLoaderAccessor addURL(URL url) throws Throwable {
        addURL.invoke(this.classLoader(), url);
        return this;
    }

    @Override
    public URLClassLoader classLoader() {
        return (URLClassLoader)super.classLoader();
    }

    public URLClassLoaderAccessor addURL(String url) throws Throwable {
        addURL.invoke(this.classLoader(), new URL(url));
        return this;
    }

    public URLClassLoaderAccessor addURL(File file) throws Throwable {
        addURL.invoke(this.classLoader(), file.toURI().toURL());
        return this;
    }

    public URLClassLoaderAccessor addURL(Path path) throws Throwable {
        addURL.invoke(this.classLoader(), path.toUri().toURL());
        return this;
    }
}

