/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import me.nullaqua.api.util.function.ConsumerWithThrow;
import me.nullaqua.api.util.function.RunWithThrow;

public class ErrorUtils {
    private static final Consumer<Throwable> thrower;
    private final Map<Class, ConsumerWithThrow> map = new HashMap<Class, ConsumerWithThrow>();

    private static void forceThrow0(Throwable t) throws Throwable {
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Throwable> void add(Class<T> t, ConsumerWithThrow<T> consumer) {
        ErrorUtils errorUtils = this;
        synchronized (errorUtils) {
            this.map.put(t, consumer);
        }
    }

    public void handleException(Throwable throwable, Class<? extends Throwable> ... x) {
        HashSet set = new HashSet();
        Collections.addAll(set, x);
        this.handleException(throwable, (Throwable t) -> {
            Class<?> c = t.getClass();
            while (Throwable.class.isAssignableFrom(c)) {
                if (set.contains(c)) {
                    ErrorUtils.forceThrow(t);
                    return;
                }
                c = c.getSuperclass();
            }
            throw new RuntimeException((Throwable)t);
        });
    }

    public void handleException(Throwable throwable, Consumer<Throwable> consumer) {
        try {
            this.throwException(throwable);
        }
        catch (Throwable t) {
            consumer.accept(t);
        }
    }

    public static void forceThrow(Throwable t) {
        thrower.accept(t);
    }

    public void throwException(Throwable throwable) throws Throwable {
        ErrorUtils errorUtils = this;
        synchronized (errorUtils) {
            Class<?> t = throwable.getClass();
            while (Throwable.class.isAssignableFrom(t)) {
                if (this.map.containsKey(t)) {
                    this.map.get(t).accept(throwable);
                    return;
                }
                t = t.getSuperclass();
            }
            throw throwable;
        }
    }

    public void handleException(Throwable throwable, Consumer<Throwable> c, Class<? extends Throwable> ... x) {
        HashSet set = new HashSet();
        Collections.addAll(set, x);
        this.handleException(throwable, (Throwable t) -> {
            Class<?> aClass = t.getClass();
            while (Throwable.class.isAssignableFrom(aClass)) {
                if (set.contains(aClass)) {
                    ErrorUtils.forceThrow(t);
                    return;
                }
                aClass = aClass.getSuperclass();
            }
            c.accept((Throwable)t);
        });
    }

    public void handle(RunWithThrow runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void handleException(Throwable throwable) {
        this.handleException(throwable, (Throwable t) -> {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        });
    }

    public <T extends Throwable> void handle(RunWithThrow run, Class<T> x) throws T {
        try {
            run.run();
        }
        catch (Throwable throwable) {
            this.handleException(throwable, x);
        }
    }

    public <T extends Throwable> void handleException(Throwable throwable, Class<T> tClass) throws T {
        this.handleException(throwable, (Throwable t) -> {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        }, tClass);
    }

    public <T extends Throwable> void handleException(Throwable throwable, Consumer<Throwable> c, Class<T> x) throws T {
        try {
            this.throwException(throwable);
        }
        catch (Throwable t) {
            if (x.isAssignableFrom(t.getClass())) {
                throw (Throwable)x.cast(t);
            }
            c.accept(t);
        }
    }

    public void handle(RunWithThrow run, Consumer<Throwable> c) {
        try {
            run.run();
        }
        catch (Throwable throwable) {
            this.handleException(throwable, c);
        }
    }

    public <T extends Throwable> void handle(RunWithThrow run, Consumer<Throwable> c, Class<T> x) throws T {
        try {
            run.run();
        }
        catch (Throwable throwable) {
            this.handleException(throwable, c, x);
        }
    }

    static {
        Method method;
        try {
            method = ErrorUtils.class.getDeclaredMethod("forceThrow0", Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        thrower = throwable -> {
            try {
                method.invoke(null, throwable);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

