/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util;

import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.nullaqua.api.util.function.RunWithThrow;

public class LoggerUtils {
    private final Logger logger;

    public LoggerUtils(Logger logger) {
        this.logger = logger;
    }

    public Logger logger() {
        return this.logger;
    }

    public void severe(String msg) {
        this.logger.severe(msg);
    }

    public void severe(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    public void severe(RunWithThrow run, String msg) {
        this.run(run, Level.SEVERE, msg);
    }

    public void severe(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.logger.warning(msg);
    }

    public void warning(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg, t);
    }

    public void warning(RunWithThrow run, String msg) {
        this.run(run, Level.WARNING, msg);
    }

    public void warning(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.WARNING, msg);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String msg, Throwable t) {
        this.logger.log(Level.INFO, msg, t);
    }

    public void info(RunWithThrow run, String msg) {
        this.run(run, Level.INFO, msg);
    }

    public void info(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.INFO, msg);
    }

    public void config(String msg) {
        this.logger.config(msg);
    }

    public void config(String msg, Throwable t) {
        this.logger.log(Level.CONFIG, msg, t);
    }

    public void config(RunWithThrow run, String msg) {
        this.run(run, Level.CONFIG, msg);
    }

    public void config(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.logger.fine(msg);
    }

    public void fine(String msg, Throwable t) {
        this.logger.log(Level.FINE, msg, t);
    }

    public void fine(RunWithThrow run, String msg) {
        this.run(run, Level.FINE, msg);
    }

    public void fine(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.FINE, msg);
    }

    public void finer(String msg) {
        this.logger.finer(msg);
    }

    public void finer(String msg, Throwable t) {
        this.logger.log(Level.FINER, msg, t);
    }

    public void finer(RunWithThrow run, String msg) {
        this.run(run, Level.FINER, msg);
    }

    public void finer(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.FINER, msg);
    }

    public void finest(String msg) {
        this.logger.finest(msg);
    }

    public void finest(String msg, Throwable t) {
        this.logger.log(Level.FINEST, msg, t);
    }

    public void finest(RunWithThrow run, String msg) {
        this.run(run, Level.FINEST, msg);
    }

    public void finest(BooleanSupplier supplier, String msg) {
        this.run(supplier, Level.FINEST, msg);
    }

    private void run(RunWithThrow run, Level level, String msg) {
        try {
            run.run();
        }
        catch (Throwable e) {
            this.logger.log(level, msg, e);
        }
    }

    private void run(BooleanSupplier supplier, Level level, String msg) {
        try {
            if (!supplier.getAsBoolean()) {
                return;
            }
        }
        catch (Throwable e) {
            this.logger.log(level, msg, e);
            return;
        }
        this.logger.log(level, msg);
    }
}

