/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class MultiThreadedSort {
    public static <T extends Comparable<? super T>> void mergeSort(List<T> list, int maxThread) {
        MultiThreadedSort.mergeSort(list, Comparator.naturalOrder(), maxThread);
    }

    public static <T> void mergeSort(List<T> list, Comparator<? super T> comparator, int maxThread) {
        Object[] array = list.toArray();
        MultiThreadedSort.mergeSort(array, comparator, maxThread);
        ListIterator<T> i = list.listIterator();
        for (Object e : array) {
            i.next();
            i.set(e);
        }
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] array, int maxThread) {
        MultiThreadedSort.mergeSort(array, 0, array.length, Comparator.naturalOrder(), maxThread);
    }

    public static <T> void mergeSort(T[] array, Comparator<? super T> comparator, int maxThread) {
        MultiThreadedSort.mergeSort(array, 0, array.length, comparator, maxThread);
    }

    private static <T> void mergeSort(T[] array, int start, int end, Comparator<? super T> comparator, int maxThread) {
        if (end - start <= 1) {
            return;
        }
        int mid = (start + end) / 2;
        if (maxThread > 0) {
            int subMaxThread0 = maxThread - 1 >> 1;
            int subMaxThread1 = maxThread - 1 - subMaxThread0;
            Thread thread = new Thread(() -> MultiThreadedSort.mergeSort(array, start, mid, comparator, subMaxThread0));
            thread.start();
            MultiThreadedSort.mergeSort(array, mid, end, comparator, subMaxThread1);
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            MultiThreadedSort.merge(array, start, mid, end, comparator);
        } else {
            Arrays.sort(array, start, end, comparator);
        }
    }

    private static <T> void merge(T[] array, int start, int mid, int end, Comparator<? super T> comparator) {
        Object[] temp = new Object[end - start];
        int i = start;
        int j = mid;
        int k = 0;
        while (i < mid && j < end) {
            if (comparator.compare(array[i], array[j]) <= 0) {
                temp[k++] = array[i++];
                continue;
            }
            temp[k++] = array[j++];
        }
        while (i < mid) {
            temp[k++] = array[i++];
        }
        while (j < end) {
            temp[k++] = array[j++];
        }
        System.arraycopy(temp, 0, array, start, end - start);
    }
}

