/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util.function;

import me.nullaqua.api.util.function.Run;

public interface RunWithThrow {
    public static <T extends Throwable> T check(Throwable throwable, Class<T> t) {
        if (t.isAssignableFrom(throwable.getClass())) {
            return (T)((Throwable)t.cast(throwable));
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    default public <T extends Throwable> void run(Class<T> t) throws T {
        try {
            this.run();
        }
        catch (Throwable throwable) {
            throw RunWithThrow.check(throwable, t);
        }
    }

    public void run() throws Throwable;

    default public Runnable toRunnable() {
        return this.toRun().toRunnable();
    }

    default public Run toRun() {
        return () -> this.run(RuntimeException.class);
    }
}

