/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util.quantity;

import me.nullaqua.api.util.quantity.DataSize;
import me.nullaqua.api.util.quantity.Time;
import me.nullaqua.api.util.quantity.unit.DataRateUnit;
import me.nullaqua.api.util.quantity.unit.DataSizeUnit;
import me.nullaqua.api.util.quantity.unit.TimeUnit;

public class DataRate {
    private final long size;
    private final long time;

    public DataRate(long size, long time) {
        this.size = size;
        this.time = time;
    }

    public DataRate(double size, DataSizeUnit sizeUnit, double time, TimeUnit timeUnit) {
        this.size = Math.round(size * (double)sizeUnit.size());
        this.time = Math.round(time * (double)timeUnit.time());
    }

    public DataRate(double rate, DataRateUnit unit) {
        this(rate, unit.sizeUnit(), unit.timeUnit());
    }

    public DataRate(double rate, DataSizeUnit sizeUnit, TimeUnit timeUnit) {
        this.size = Math.round(rate * (double)sizeUnit.size());
        this.time = timeUnit.time();
    }

    public DataRate(DataSize size, Time time) {
        this.size = size.size();
        this.time = time.time();
    }

    public DataRate(DataSize size, TimeUnit timeUnit) {
        this.size = size.size();
        this.time = timeUnit.time();
    }

    public DataRate(DataSizeUnit sizeUnit, Time time) {
        this.size = sizeUnit.size();
        this.time = time.time();
    }

    public long size() {
        return this.size;
    }

    public long time() {
        return this.time;
    }

    public double rate(DataSizeUnit sizeUnit, TimeUnit timeUnit) {
        return this.size(sizeUnit) / this.time(timeUnit);
    }

    public double size(DataSizeUnit unit) {
        return (double)this.size * 1.0 / (double)unit.size();
    }

    public double time(TimeUnit unit) {
        return (double)this.time * 1.0 / (double)unit.time();
    }

    public String toString(DataSizeUnit sizeUnit, TimeUnit timeUnit) {
        return this.toString(sizeUnit, timeUnit, 2);
    }

    public String toString(DataRateUnit unit) {
        return this.toString(unit, 2);
    }

    public String toString(DataRateUnit unit, int decimal) {
        return this.toString(unit.sizeUnit(), unit.timeUnit(), decimal);
    }

    public String toString(DataSizeUnit sizeUnit, TimeUnit timeUnit, int decimal) {
        return String.format("%." + decimal + "f %s/%s", new Object[]{this.rate(new DataRateUnit(sizeUnit, timeUnit)), sizeUnit, timeUnit});
    }

    public double rate(DataRateUnit unit) {
        return this.size(unit) / this.time(unit);
    }

    public double size(DataRateUnit unit) {
        return this.size(unit.sizeUnit());
    }

    public double time(DataRateUnit unit) {
        return this.time(unit.timeUnit());
    }

    public String toString(TimeUnit unit) {
        DataRateUnit dataRateUnit = new DataRateUnit(DataSizeUnit.TB, unit);
        if (this.rate(dataRateUnit) > 1.0) {
            return this.toString(DataSizeUnit.TB, unit);
        }
        DataRateUnit dataRateUnit2 = new DataRateUnit(DataSizeUnit.GB, unit);
        if (this.rate(dataRateUnit2) > 1.0) {
            return this.toString(DataSizeUnit.GB, unit);
        }
        DataRateUnit dataRateUnit3 = new DataRateUnit(DataSizeUnit.MB, unit);
        if (this.rate(dataRateUnit3) > 1.0) {
            return this.toString(DataSizeUnit.MB, unit);
        }
        DataRateUnit dataRateUnit4 = new DataRateUnit(DataSizeUnit.KB, unit);
        if (this.rate(dataRateUnit4) > 1.0) {
            return this.toString(DataSizeUnit.KB, unit);
        }
        return this.toString(DataSizeUnit.B, unit);
    }

    public String toString() {
        return this.toString(TimeUnit.s);
    }

    public DataRate add(DataRate dataRate) {
        return new DataRate(this.rate(DataSizeUnit.B, TimeUnit.s) + dataRate.rate(DataSizeUnit.B, TimeUnit.s), DataSizeUnit.B, TimeUnit.s);
    }

    public DataRate sub(DataRate dataRate) {
        return new DataRate(this.rate(DataSizeUnit.B, TimeUnit.s) - dataRate.rate(DataSizeUnit.B, TimeUnit.s), DataSizeUnit.B, TimeUnit.s);
    }
}

