/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util.quantity;

import me.nullaqua.api.util.quantity.unit.DataSizeUnit;

public class DataSize {
    private final long size;

    public DataSize(long size) {
        this.size = size;
    }

    public DataSize(double size, DataSizeUnit unit) {
        this.size = Math.round(size * (double)unit.size());
    }

    public long size() {
        return this.size;
    }

    public String toString() {
        if (this.size >> 40 > 0L) {
            return this.toString(DataSizeUnit.TB);
        }
        if (this.size >> 30 > 0L) {
            return this.toString(DataSizeUnit.GB);
        }
        if (this.size >> 20 > 0L) {
            return this.toString(DataSizeUnit.MB);
        }
        if (this.size >> 10 > 0L) {
            return this.toString(DataSizeUnit.KB);
        }
        return this.toString(DataSizeUnit.B);
    }

    public String toString(DataSizeUnit unit) {
        return this.toString(unit, 2);
    }

    public String toString(DataSizeUnit unit, int decimal) {
        return String.format("%." + decimal + "f %s", new Object[]{this.size(unit), unit});
    }

    public double size(DataSizeUnit unit) {
        return (double)this.size * 1.0 / (double)unit.size();
    }

    public DataSize add(DataSize other) {
        return new DataSize(this.size + other.size);
    }

    public DataSize sub(DataSize other) {
        return new DataSize(this.size - other.size);
    }
}

