/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util.quantity;

import me.nullaqua.api.util.quantity.unit.DistanceUnit;

public class Distance {
    private final double distance;

    public Distance(double distance) {
        this.distance = distance;
    }

    public Distance(double distance, DistanceUnit unit) {
        this.distance = distance * unit.distance();
    }

    public double distance() {
        return this.distance;
    }

    public String toString() {
        if (this.distance > DistanceUnit.KM.distance()) {
            return this.toString(DistanceUnit.KM);
        }
        if (this.distance > DistanceUnit.M.distance()) {
            return this.toString(DistanceUnit.M);
        }
        if (this.distance > DistanceUnit.DM.distance()) {
            return this.toString(DistanceUnit.DM);
        }
        if (this.distance > DistanceUnit.CM.distance()) {
            return this.toString(DistanceUnit.CM);
        }
        if (this.distance > DistanceUnit.MM.distance()) {
            return this.toString(DistanceUnit.MM);
        }
        if (this.distance > DistanceUnit.UM.distance()) {
            return this.toString(DistanceUnit.UM);
        }
        return this.toString(DistanceUnit.NM);
    }

    public String toString(DistanceUnit unit) {
        return this.toString(unit, 2);
    }

    public String toString(DistanceUnit unit, int decimal) {
        return String.format("%." + decimal + "f %s", new Object[]{this.distance(unit), unit});
    }

    public double distance(DistanceUnit unit) {
        return this.distance / unit.distance();
    }

    public Distance add(Distance distance) {
        return new Distance(this.distance + distance.distance);
    }

    public Distance sub(Distance distance) {
        return new Distance(this.distance - distance.distance);
    }
}

