/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.util.quantity;

import me.nullaqua.api.util.quantity.unit.TimeUnit;

public class Time {
    private final long time;

    public Time(long time) {
        this.time = time;
    }

    public Time(double time, TimeUnit unit) {
        this.time = Math.round(time * (double)unit.time());
    }

    public long time() {
        return this.time;
    }

    public String toString() {
        if (this.time > TimeUnit.day.time()) {
            return this.toString(TimeUnit.day);
        }
        if (this.time > TimeUnit.h.time()) {
            return this.toString(TimeUnit.h);
        }
        if (this.time > TimeUnit.min.time()) {
            return this.toString(TimeUnit.min);
        }
        if (this.time > TimeUnit.s.time()) {
            return this.toString(TimeUnit.s);
        }
        return this.toString(TimeUnit.ms);
    }

    public String toString(TimeUnit unit) {
        return this.toString(unit, 2);
    }

    public String toString(TimeUnit unit, int decimal) {
        return String.format("%." + decimal + "f %s", new Object[]{this.time(unit), unit});
    }

    public double time(TimeUnit unit) {
        return (double)this.time * 1.0 / (double)unit.time();
    }

    public Time add(Time other) {
        return new Time(this.time + other.time);
    }

    public Time sub(Time other) {
        return new Time(this.time - other.time);
    }
}

