/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.InheritanceType;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import org.apache.commons.collections.collection.CompositeCollection;

public class CFMappingDef<T, I> {
    private Class<T> realClass;
    private Class<T> effectiveClass;
    private CFMappingDef<? super T, I> cfBaseMapDef;
    private CFMappingDef<? super T, I> cfSuperMapDef;
    private String colFamName;
    private InheritanceType inheritanceType;
    private String discColumn;
    private DiscriminatorType discType;
    private Object discValue;
    private Set<PropertyMappingDefinition<I>> idPropertySet = new HashSet<PropertyMappingDefinition<I>>();
    private Map<Object, CFMappingDef<? extends T, I>> derivedClassMap = new HashMap<Object, CFMappingDef<? extends T, I>>();
    private Collection<PropertyMappingDefinition<?>> allMappedProps;
    private Map<String, PropertyMappingDefinition<?>> propertyCacheByPropName = new HashMap();
    private Map<String, PropertyMappingDefinition<?>> propertyCacheByColName = new HashMap();

    public CFMappingDef(Class<T> clazz) {
        this.setDefaults(clazz);
    }

    public void setDefaults(Class<T> realClass) {
        boolean entityFound;
        this.realClass = realClass;
        this.effectiveClass = realClass;
        while (!(entityFound = null != this.effectiveClass.getAnnotation(Entity.class)) && this.effectiveClass.isAnonymousClass()) {
            this.effectiveClass = this.effectiveClass.getSuperclass();
        }
        if (!entityFound) {
            throw new HectorObjectMapperException("class, " + realClass.getName() + ", not annotated with @" + Entity.class.getSimpleName());
        }
    }

    public void addDerivedClassMap(CFMappingDef<? extends T, I> cfDerivedMapDef) {
        this.derivedClassMap.put(cfDerivedMapDef.getDiscValue(), cfDerivedMapDef);
    }

    public PropertyMappingDefinition<?> getPropMapByPropName(String propName) {
        return this.propertyCacheByPropName.get(propName);
    }

    public PropertyMappingDefinition<?> getPropMapByColumnName(String colName) {
        PropertyMappingDefinition<?> md = this.propertyCacheByColName.get(colName);
        if (null != md) {
            return md;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getPropMapByColumnName(colName);
        }
        return null;
    }

    public void addPropertyDefinition(PropertyMappingDefinition<?> propDef) {
        this.propertyCacheByColName.put(propDef.getColName(), propDef);
        this.propertyCacheByPropName.put(propDef.getPropDesc().getName(), propDef);
    }

    public String getColFamName() {
        return this.colFamName;
    }

    public String getEffectiveColFamName() {
        if (null != this.colFamName) {
            return this.colFamName;
        }
        if (null != this.cfBaseMapDef) {
            return this.cfBaseMapDef.getColFamName();
        }
        throw new HectorObjectMapperException("trying to get ColumnFamily name, but is missing for mapping, " + this.toString());
    }

    public Class<T> getEffectiveClass() {
        return this.effectiveClass;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public void setInheritanceType(InheritanceType inheritanceType) {
        this.inheritanceType = inheritanceType;
    }

    public String getDiscColumn() {
        if (null == this.cfBaseMapDef) {
            return this.discColumn;
        }
        return this.cfBaseMapDef.getDiscColumn();
    }

    public void setDiscColumn(String discColumn) {
        this.discColumn = discColumn;
    }

    public DiscriminatorType getDiscType() {
        if (null == this.cfBaseMapDef) {
            return this.discType;
        }
        return this.cfBaseMapDef.getDiscType();
    }

    public void setDiscType(DiscriminatorType discType) {
        this.discType = discType;
    }

    public Object getDiscValue() {
        return this.discValue;
    }

    public void setDiscValue(Object discValue) {
        this.discValue = discValue;
    }

    public Set<PropertyMappingDefinition<I>> getIdPropertySet() {
        if (null == this.cfBaseMapDef) {
            return this.idPropertySet;
        }
        return this.cfBaseMapDef.getIdPropertySet();
    }

    public void addIdPropertyMap(PropertyMappingDefinition<I> idProperty) {
        this.idPropertySet.add(idProperty);
    }

    public Collection<PropertyMappingDefinition<?>> getAllProperties() {
        if (null == this.allMappedProps) {
            HashSet propSet = new HashSet();
            for (PropertyMappingDefinition<?> propMapDef : this.propertyCacheByColName.values()) {
                propSet.add(propMapDef);
            }
            this.allMappedProps = null == this.cfSuperMapDef ? propSet : new CompositeCollection(new Collection[]{propSet, this.cfSuperMapDef.getAllProperties()});
        }
        return this.allMappedProps;
    }

    public CFMappingDef<? super T, I> getCfBaseMapDef() {
        return this.cfBaseMapDef;
    }

    public void setCfBaseMapDef(CFMappingDef<? super T, I> cfBaseMapDef) {
        this.cfBaseMapDef = cfBaseMapDef;
    }

    public void setColFamName(String colFamName) {
        this.colFamName = colFamName;
    }

    public Map<Object, CFMappingDef<? extends T, I>> getDerivedClassMap() {
        return this.derivedClassMap;
    }

    public CFMappingDef<? super T, I> getCfSuperMapDef() {
        return this.cfSuperMapDef;
    }

    public void setCfSuperMapDef(CFMappingDef<? super T, I> cfSuperMapDef) {
        this.cfSuperMapDef = cfSuperMapDef;
    }

    public Class<T> getRealClass() {
        return this.realClass;
    }

    public String toString() {
        return "CFMappingDef [colFamName=" + this.colFamName + ", realClass=" + this.realClass + ", effectiveClass=" + this.effectiveClass + "]";
    }

    public boolean isBaseInheritanceClass() {
        return null != this.inheritanceType;
    }

    public boolean isDerivedClassInheritance() {
        return !this.isBaseInheritanceClass() && null != this.getDiscValue();
    }

    public boolean isStandaloneClass() {
        return !this.isBaseInheritanceClass() && !this.isDerivedClassInheritance();
    }
}

