/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hom.EntityManagerConfigurator;
import me.prettyprint.hom.EntityManagerImpl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    private Logger log = LoggerFactory.getLogger(EntityManagerFactoryImpl.class);
    private EntityManagerConfigurator entityManagerConfigurator;
    private Cluster cluster;

    public EntityManagerFactoryImpl() {
    }

    public EntityManagerFactoryImpl(Map<String, Object> properties) {
        this(new EntityManagerConfigurator(properties));
    }

    public EntityManagerFactoryImpl(EntityManagerConfigurator entityManagerConfigurator) {
        this.entityManagerConfigurator = entityManagerConfigurator;
        this.cluster = HFactory.getOrCreateCluster((String)entityManagerConfigurator.getClusterName(), (CassandraHostConfigurator)entityManagerConfigurator.getCassandraHostConfigurator());
    }

    public void close() {
        this.cluster.getConnectionManager().shutdown();
    }

    public EntityManager createEntityManager() {
        this.log.debug("building EMF");
        return this.buildEntityManager(this.entityManagerConfigurator.getKeyspace());
    }

    private EntityManagerImpl buildEntityManager(String keyspace) {
        EntityManagerImpl entityManager = new EntityManagerImpl(HFactory.createKeyspace((String)keyspace, (Cluster)this.cluster), this.entityManagerConfigurator.getClasspathPrefix());
        this.log.debug("Built entityManager {}", (Object)entityManager);
        return entityManager;
    }

    public EntityManager createEntityManager(Map map) {
        this.log.debug("building EMF with props");
        String keyspaceStr = EntityManagerConfigurator.getPropertyGently(map, "me.prettyprint.hom.keyspace", false);
        if (StringUtils.isBlank((String)keyspaceStr)) {
            keyspaceStr = this.entityManagerConfigurator.getKeyspace();
        }
        return this.buildEntityManager(keyspaceStr);
    }

    public boolean isOpen() {
        try {
            this.cluster.describeClusterName();
            return true;
        }
        catch (HectorException he) {
            this.log.debug("isOpen failed to connecto to cluster: {}", (Object)he.getMessage());
            return false;
        }
    }

    public Cache getCache() {
        return null;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    public Metamodel getMetamodel() {
        return null;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }
}

