/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.HectorObjectMapper;
import me.prettyprint.hom.annotations.AnnotationScanner;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl
implements EntityManager {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerImpl.class);
    private Keyspace keyspace;
    private HectorObjectMapper objMapper;
    private ClassCacheMgr cacheMgr;
    private boolean open;

    public EntityManagerImpl(Keyspace keyspace, String classpathPrefix) {
        this(keyspace, new String[]{classpathPrefix}, null, null);
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix) {
        this(keyspace, classpathPrefix, null, null);
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix, ClassCacheMgr cacheMgr, HectorObjectMapper objMapper) {
        this.keyspace = keyspace;
        this.cacheMgr = null != cacheMgr ? cacheMgr : new ClassCacheMgr();
        this.objMapper = null != objMapper ? objMapper : new HectorObjectMapper(this.cacheMgr);
        this.initialize(classpathPrefix);
    }

    public void initialize(String[] classpathPrefixArr) {
        if (null != classpathPrefixArr && 0 < classpathPrefixArr.length) {
            for (String classpathPrefix : classpathPrefixArr) {
                this.initializeClasspath(classpathPrefix);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("classpath array has {} items : {}", null != classpathPrefixArr ? Integer.valueOf(classpathPrefixArr.length) : "0", (Object)classpathPrefixArr);
        }
        this.open = true;
    }

    private void initializeClasspath(String classpathPrefix) {
        AnnotationScanner scanner = new AnnotationScanner();
        Set<Class<?>> classSet = scanner.scan(classpathPrefix, Entity.class);
        for (Class<?> clazz : classSet) {
            this.cacheMgr.initializeCacheForClass(clazz);
        }
    }

    public <T, I> T load(Class<T> clazz, I id) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        return this.objMapper.getObject(this.keyspace, cfMapDef.getEffectiveColFamName(), clazz, id);
    }

    public <T, I> T load(Class<T> clazz, I id, ColumnSlice<String, byte[]> colSlice) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        T obj = this.objMapper.createObject(cfMapDef, id, colSlice);
        return obj;
    }

    public <T> T save(T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        return this.objMapper.saveObj(this.keyspace, obj);
    }

    public void persist(Object entity) {
        this.save(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.load(entityClass, primaryKey);
    }

    public void clear() {
    }

    public void close() {
    }

    public boolean contains(Object entity) {
        return false;
    }

    public Query createNamedQuery(String name) {
        return null;
    }

    public Query createNativeQuery(String sqlString) {
        return null;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return null;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return null;
    }

    public Query createQuery(String qlString) {
        return null;
    }

    public void flush() {
    }

    public Object getDelegate() {
        return null;
    }

    public FlushModeType getFlushMode() {
        return null;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return null;
    }

    public EntityTransaction getTransaction() {
        return null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void joinTransaction() {
    }

    public void lock(Object entity, LockModeType lockMode) {
    }

    public <T> T merge(T entity) {
        return null;
    }

    public void refresh(Object entity) {
    }

    public void remove(Object entity) {
    }

    public void setFlushMode(FlushModeType flushMode) {
    }

    public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
        return null;
    }

    public void detach(Object arg0) {
    }

    public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
        return null;
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
        return null;
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        return null;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return null;
    }

    public LockModeType getLockMode(Object arg0) {
        return null;
    }

    public Metamodel getMetamodel() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
    }

    public void refresh(Object arg0, LockModeType arg1) {
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
    }

    public void setProperty(String arg0, Object arg1) {
    }

    public <T> T unwrap(Class<T> arg0) {
        return null;
    }
}

