/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.DiscriminatorType;
import javax.persistence.Id;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.ObjectSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.annotations.AnonymousPropertyAddHandler;
import me.prettyprint.hom.annotations.AnonymousPropertyCollectionGetter;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HectorObjectMapper {
    private static Logger logger = LoggerFactory.getLogger(HectorObjectMapper.class);
    private static final int MAX_NUM_COLUMNS = 100;
    private int maxNumColumns = 100;
    private ClassCacheMgr cacheMgr;

    public HectorObjectMapper(ClassCacheMgr cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    public <T, I> T getObject(Keyspace keyspace, String colFamName, Class<T> clazz, I id) {
        if (null == id) {
            throw new IllegalArgumentException("object ID cannot be null or empty");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(colFamName, true);
        PropertyMappingDefinition md = cfMapDef.getIdPropertySet().iterator().next();
        if (null == md) {
            throw new HectorObjectMapperException("Trying to build new object but haven't annotated a field with @" + Id.class.getSimpleName());
        }
        byte[] idAsBytes = md.getConverter().convertObjTypeToCassType(id);
        SliceQuery q = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)BytesArraySerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        q.setColumnFamily(colFamName);
        q.setKey((Object)idAsBytes);
        q.setRange((Object)"", (Object)"", false, this.maxNumColumns);
        QueryResult result = q.execute();
        if (null == result || null == result.get()) {
            return null;
        }
        Object obj = this.createObject(cfMapDef, id, (ColumnSlice<String, byte[]>)((ColumnSlice)result.get()));
        return obj;
    }

    public <T, I> T saveObj(Keyspace keyspace, T obj) {
        byte[] bytes;
        if (null == obj) {
            throw new IllegalArgumentException("object cannot be null");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(obj.getClass(), true);
        PropertyMappingDefinition md = cfMapDef.getIdPropertySet().iterator().next();
        if (null == md) {
            throw new HectorObjectMapperException("Trying to save object but haven't annotated a field with @" + Id.class.getSimpleName());
        }
        Method meth = md.getPropDesc().getReadMethod();
        if (null == meth) {
            logger.debug("@Id annotation found - but can't find getter for property, " + md.getPropDesc().getName());
        }
        try {
            Object retVal = meth.invoke(obj, (Object[])null);
            bytes = md.getConverter().convertObjTypeToCassType(retVal);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (null == bytes) {
            throw new IllegalArgumentException("object ID cannot be null or empty");
        }
        Collection<HColumn<String, byte[]>> colColl = this.createColumnSet(obj);
        String colFamName = cfMapDef.getEffectiveColFamName();
        Mutator m = HFactory.createMutator((Keyspace)keyspace, (Serializer)BytesArraySerializer.get());
        for (HColumn<String, byte[]> col : colColl) {
            m.addInsertion((Object)bytes, colFamName, col);
        }
        m.execute();
        return obj;
    }

    <T, I> T createObject(CFMappingDef<T, I> cfMapDef, I id, ColumnSlice<String, byte[]> slice) {
        if (slice.getColumns().isEmpty()) {
            return null;
        }
        CFMappingDef<T, I> cfMapDefInstance = this.determineClassType(cfMapDef, slice);
        try {
            T obj = cfMapDefInstance.getEffectiveClass().newInstance();
            this.setIdIfCan(cfMapDef, obj, id);
            for (HColumn col : slice.getColumns()) {
                String colName = (String)col.getName();
                PropertyMappingDefinition<?> md = cfMapDefInstance.getPropMapByColumnName(colName);
                if (null != md && null != md.getPropDesc()) {
                    this.setPropertyUsingColumn(obj, (HColumn<String, byte[]>)col, md);
                    continue;
                }
                if (null != cfMapDef.getDiscColumn() && colName.equals(cfMapDef.getDiscColumn())) continue;
                this.addToExtraIfCan(obj, (HColumn<String, byte[]>)col);
            }
            return obj;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<HColumn<String, byte[]>> createColumnSet(Object obj) {
        Map<String, HColumn<String, byte[]>> map = this.createColumnMap(obj);
        if (null != map) {
            return map.values();
        }
        return null;
    }

    <T, I> Map<String, HColumn<String, byte[]>> createColumnMap(T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(obj.getClass(), true);
        try {
            HashMap<String, HColumn<String, byte[]>> colSet = new HashMap<String, HColumn<String, byte[]>>();
            Collection<PropertyMappingDefinition<?>> coll = cfMapDef.getAllProperties();
            for (PropertyMappingDefinition<?> md : coll) {
                HColumn<String, byte[]> col = this.createColumnFromProperty(obj, md);
                if (null == col) continue;
                colSet.put((String)col.getName(), col);
            }
            if (null != cfMapDef.getCfBaseMapDef()) {
                CFMappingDef cfSuperMapDef = cfMapDef.getCfBaseMapDef();
                String discColName = cfSuperMapDef.getDiscColumn();
                DiscriminatorType discType = cfSuperMapDef.getDiscType();
                colSet.put(discColName, this.createHColumn(discColName, this.convertDiscTypeToColValue(discType, cfMapDef.getDiscValue())));
            }
            this.addAnonymousProperties(obj, colSet);
            return colSet;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAnonymousProperties(Object obj, Map<String, HColumn<String, byte[]>> colSet) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method meth = this.findAnnotatedMethod(obj.getClass(), AnonymousPropertyCollectionGetter.class);
        if (null == meth) {
            return;
        }
        Collection propColl = (Collection)meth.invoke(obj, (Object[])null);
        if (null == propColl || propColl.isEmpty()) {
            return;
        }
        for (Map.Entry entry : propColl) {
            colSet.put((String)entry.getKey(), (HColumn<String, byte[]>)HFactory.createColumn(entry.getKey(), (Object)((String)entry.getValue()).getBytes(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get()));
        }
    }

    private <T, P> HColumn<String, byte[]> createColumnFromProperty(T obj, PropertyMappingDefinition<P> md) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] colValue = this.createBytesFromPropertyValue(obj, md);
        if (null == colValue) {
            return null;
        }
        HColumn<String, byte[]> col = this.createHColumn(md.getColName(), colValue);
        return col;
    }

    private <P> byte[] createBytesFromPropertyValue(Object obj, PropertyMappingDefinition<P> md) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor pd = md.getPropDesc();
        Method getter = pd.getReadMethod();
        if (null == getter) {
            throw new RuntimeException("missing getter method for property, " + pd.getName());
        }
        Object retVal = getter.invoke(obj, (Object[])null);
        if (null == retVal) {
            return null;
        }
        byte[] bytes = md.getConverter().convertObjTypeToCassType(retVal);
        return bytes;
    }

    private HColumn<String, byte[]> createHColumn(String name, byte[] value) {
        return HFactory.createColumn((Object)name, (Object)value, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
    }

    private <T, I> CFMappingDef<? extends T, I> determineClassType(CFMappingDef<T, I> cfMapDef, ColumnSlice<String, byte[]> slice) {
        if (null == cfMapDef.getInheritanceType()) {
            return cfMapDef;
        }
        if (null == slice || null == slice.getColumns() || slice.getColumns().isEmpty()) {
            return cfMapDef;
        }
        String discColName = cfMapDef.getDiscColumn();
        DiscriminatorType discType = cfMapDef.getDiscType();
        Map<Object, CFMappingDef<T, I>> derivedClasses = cfMapDef.getDerivedClassMap();
        HColumn discCol = null;
        for (HColumn col : slice.getColumns()) {
            if (!((String)col.getName()).equals(discColName)) continue;
            discCol = col;
            break;
        }
        if (null == discCol || 0 == ((byte[])discCol.getValue()).length) {
            return cfMapDef;
        }
        Object discValue = this.convertColValueToDiscType(discType, (byte[])discCol.getValue());
        CFMappingDef<T, I> derivedCfMapDef = derivedClasses.get(discValue);
        if (null == derivedCfMapDef) {
            throw new RuntimeException("Cannot find derived class of " + cfMapDef.getEffectiveClass().getName() + " with discriminator value of " + discValue);
        }
        return derivedCfMapDef;
    }

    private Object convertColValueToDiscType(DiscriminatorType discType, byte[] value) {
        switch (discType) {
            case STRING: {
                return new String(value);
            }
            case CHAR: {
                return Character.valueOf(ByteBuffer.wrap(value).asCharBuffer().get());
            }
            case INTEGER: {
                return IntegerSerializer.get().fromBytes(value);
            }
        }
        throw new RuntimeException("must have added a new discriminator type, " + discType + ", because don't know how to convert db value - cannot continue");
    }

    private byte[] convertDiscTypeToColValue(DiscriminatorType discType, Object value) {
        switch (discType) {
            case STRING: {
                return StringSerializer.get().toBytes((Object)((String)value));
            }
            case CHAR: {
                return String.valueOf((Character)value).getBytes();
            }
            case INTEGER: {
                return IntegerSerializer.get().toBytes((Object)((Integer)value));
            }
        }
        throw new RuntimeException("must have added a new discriminator type, " + discType + ", because don't know how to convert db value - cannot continue");
    }

    private <T, I> void setIdIfCan(CFMappingDef<T, I> cfMapDef, T obj, I id) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyMappingDefinition<I> md = cfMapDef.getIdPropertySet().iterator().next();
        if (null == md) {
            throw new HectorObjectMapperException("Trying to build new object but haven't annotated a field with @" + Id.class.getSimpleName());
        }
        Method meth = md.getPropDesc().getWriteMethod();
        if (null == meth) {
            logger.debug("@Id annotation found - but can't find setter for property, " + md.getPropDesc().getName());
        }
        meth.invoke(obj, id);
    }

    private <T, P> void setPropertyUsingColumn(T obj, HColumn<String, byte[]> col, PropertyMappingDefinition<P> md) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor pd = md.getPropDesc();
        if (null == pd.getWriteMethod()) {
            throw new RuntimeException("property, " + pd.getName() + ", does not have a setter and therefore cannot be set");
        }
        P value = md.getConverter().convertCassTypeToObjType(pd.getPropertyType(), (byte[])col.getValue());
        pd.getWriteMethod().invoke(obj, value);
    }

    public static Serializer<?> determineSerializer(Class<?> theType) {
        LongSerializer s = null;
        if (theType == Long.class || theType == Long.TYPE) {
            s = LongSerializer.get();
        } else if (theType == String.class) {
            s = StringSerializer.get();
        } else if (theType == Integer.class || theType == Integer.TYPE) {
            s = IntegerSerializer.get();
        } else if (theType == UUID.class) {
            s = UUIDSerializer.get();
        } else if (theType == Boolean.class || theType == Boolean.TYPE) {
            s = BooleanSerializer.get();
        } else if (theType == Date.class) {
            s = DateSerializer.get();
        } else if (theType == byte[].class) {
            s = BytesArraySerializer.get();
        } else if (theType == Double.class || theType == Double.TYPE) {
            s = DoubleSerializer.get();
        } else if (HectorObjectMapper.isSerializable(theType)) {
            s = ObjectSerializer.get();
        } else {
            throw new RuntimeException("unsupported property type, " + theType.getName());
        }
        return s;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return HectorObjectMapper.isImplementedBy(clazz, Serializable.class);
    }

    public static boolean isImplementedBy(Class<?> clazz, Class<?> target) {
        if (null == clazz || null == target) {
            return false;
        }
        Class<?>[] interArr = clazz.getInterfaces();
        if (null == interArr) {
            return false;
        }
        for (Class<?> interfa : interArr) {
            if (!interfa.equals(target)) continue;
            return true;
        }
        return false;
    }

    private void addToExtraIfCan(Object obj, HColumn<String, byte[]> col) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method meth = this.findAnnotatedMethod(obj.getClass(), AnonymousPropertyAddHandler.class);
        if (null == meth) {
            throw new IllegalArgumentException("Object type, " + obj.getClass() + ", does not have a property named, " + (String)col.getName() + ".  either add a setter for this property or use @AnonymousPropertyHandler to annotate a method for handling anonymous properties");
        }
        meth.invoke(obj, col.getName(), StringSerializer.get().fromBytes((byte[])col.getValue()));
    }

    private Method findAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> anno) {
        for (Method meth : clazz.getMethods()) {
            if (!meth.isAnnotationPresent(anno)) continue;
            return meth;
        }
        return null;
    }
}

