/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.persistence.IdClass;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.ParserValidator;

public class IdClassParserValidator
implements ParserValidator {
    @Override
    public <T, I> void parse(ClassCacheMgr cacheMgr, Annotation anno, CFMappingDef<T, I> cfMapDef) {
        if (!(anno instanceof IdClass)) {
            throw new HectorObjectMapperException("This class cannot parse annotation " + anno.getClass().getSimpleName());
        }
        this.parseIdClassAnnotation(cacheMgr, (IdClass)anno, cfMapDef);
    }

    @Override
    public <T, I> void validateAndSetDefaults(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
    }

    private <T, I> void parseIdClassAnnotation(ClassCacheMgr cacheMgr, IdClass anno, CFMappingDef<T, I> cfMapDef) {
        Class pkClazz = anno.value();
        this.verifyClassConformsToJpaSpec(pkClazz);
        try {
            Map<String, PropertyDescriptor> pdMap = cacheMgr.getFieldPropertyDescriptorMap(pkClazz);
        }
        catch (IntrospectionException e) {
            throw new HectorObjectMapperException("exception while introspecting class, " + pkClazz.getName(), e);
        }
    }

    private void verifyClassConformsToJpaSpec(Class<?> pkClazz) {
        if (!Serializable.class.isAssignableFrom(pkClazz)) {
            throw new HectorObjectMapperException("JPA requires that primary key class, " + pkClazz.getName() + ", must be Serializable");
        }
    }
}

