/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.lang.annotation.Annotation;
import javax.persistence.Inheritance;
import javax.persistence.Table;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.ParserValidator;

public class TableParserValidator
implements ParserValidator {
    @Override
    public <T, I> void parse(ClassCacheMgr cacheMgr, Annotation anno, CFMappingDef<T, I> cfMapDef) {
        if (!(anno instanceof Table)) {
            throw new HectorObjectMapperException("This class cannot parse annotation " + anno.getClass().getSimpleName());
        }
        this.parseTableAnnotation(cacheMgr, (Table)anno, cfMapDef);
    }

    private <T, I> void parseTableAnnotation(ClassCacheMgr cacheMgr, Table anno, CFMappingDef<T, I> cfMapDef) {
        CFMappingDef tmpDef = cacheMgr.getCfMapDef(anno.name(), false);
        if (null != tmpDef) {
            throw new HectorObjectMapperException("classes, " + cfMapDef.getEffectiveClass().getName() + " and " + tmpDef.getEffectiveClass().getName() + ", are both mapped to ColumnFamily, " + tmpDef.getEffectiveColFamName() + ".  Can only have one Class/ColumnFamily mapping - if multiple classes can be derived from a single ColumnFamily, use @" + Inheritance.class.getSimpleName());
        }
        cfMapDef.setColFamName(anno.name());
    }

    @Override
    public <T, I> void validateAndSetDefaults(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
        if (cfMapDef.isStandaloneClass()) {
            this.validateStandaloneClass(cacheMgr, cfMapDef);
        } else if (cfMapDef.isBaseInheritanceClass()) {
            this.validateBaseClass(cacheMgr, cfMapDef);
        } else if (cfMapDef.isDerivedClassInheritance()) {
            this.validateDerivedClass(cacheMgr, cfMapDef);
        }
    }

    private <T, I> void validateStandaloneClass(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
        if (null == cfMapDef.getEffectiveColFamName()) {
            throw new HectorObjectMapperException("Class, " + cfMapDef.getRealClass().getName() + ", is missing @" + Table.class.getSimpleName());
        }
        CFMappingDef<T, I> cfSuperDef = cacheMgr.findBaseClassViaMappings(cfMapDef);
        if (null != cfSuperDef) {
            throw new HectorObjectMapperException("@" + Table.class.getSimpleName() + " can only be used once per hierarchy and has been specified in class " + cfSuperDef.getRealClass().getName() + " and " + cfMapDef.getRealClass().getName() + " - quitting");
        }
    }

    private <T, I> void validateBaseClass(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
        if (null == cfMapDef.getColFamName()) {
            throw new HectorObjectMapperException(cfMapDef.getRealClass() + " is recognized as a base class, but doesn't specify @" + Table.class.getSimpleName() + " - quitting");
        }
    }

    private <T, I> void validateDerivedClass(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
        this.findAndSetBaseClassViaMappings(cacheMgr, cfMapDef);
        if (null == cfMapDef.getCfBaseMapDef()) {
            throw new HectorObjectMapperException("@" + Table.class.getSimpleName() + " used by class, " + cfMapDef.getRealClass().getName() + ", " + " has already been specified by base class, " + cfMapDef.getCfBaseMapDef().getEffectiveClass().getName());
        }
        cfMapDef.getCfBaseMapDef().addDerivedClassMap(cfMapDef);
    }

    private <T, I> void findAndSetBaseClassViaMappings(ClassCacheMgr cacheMgr, CFMappingDef<T, I> cfMapDef) {
        CFMappingDef<T, I> cfBaseMapDef = cacheMgr.findBaseClassViaMappings(cfMapDef);
        if (null == cfBaseMapDef) {
            throw new HectorObjectMapperException(cfMapDef.getRealClass() + " is a derived class entity but @" + Table.class.getSimpleName() + " is not specified in its super classes - quitting");
        }
        cfMapDef.setCfBaseMapDef(cfBaseMapDef);
    }
}

