/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.openjpa;

import java.util.Map;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.model.MutatorImpl;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.utils.StringUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hom.openjpa.CassandraStoreConfiguration;
import me.prettyprint.hom.openjpa.EntityFacade;
import me.prettyprint.hom.openjpa.MappingUtils;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStore {
    private static final Logger log = LoggerFactory.getLogger(CassandraStore.class);
    private final Cluster cluster;
    private final CassandraStoreConfiguration conf;
    private Keyspace keyspace;
    private MappingUtils mappingUtils;

    public CassandraStore(CassandraStoreConfiguration conf) {
        this.conf = conf;
        this.cluster = HFactory.getCluster((String)conf.getValue("me.prettyprint.hom.clusterName").getOriginalValue());
        this.mappingUtils = new MappingUtils();
    }

    public CassandraStore open() {
        this.keyspace = HFactory.createKeyspace((String)this.conf.getValue("me.prettyprint.hom.keyspace").getOriginalValue(), (Cluster)this.cluster);
        return this;
    }

    public <I> boolean getObject(OpenJPAStateManager stateManager, I idObj) {
        ClassMetaData metaData = stateManager.getMetaData();
        EntityFacade entityFacade = new EntityFacade(metaData);
        SliceQuery<byte[], String, byte[]> sliceQuery = this.mappingUtils.buildSliceQuery(idObj, entityFacade, this.keyspace);
        QueryResult result = sliceQuery.execute();
        stateManager.storeString(1, StringUtils.string((byte[])((byte[])((ColumnSlice)result.get()).getColumnByName((Object)"name").getValue())));
        stateManager.storeObject(0, idObj);
        return true;
    }

    public Mutator storeObject(Mutator mutator, OpenJPAStateManager stateManager, Object idObj) {
        if (mutator == null) {
            mutator = new MutatorImpl(this.keyspace, (Serializer)BytesArraySerializer.get());
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding mutation (insertion) for class {}", (Object)stateManager.getManagedInstance().getClass().getName());
        }
        ClassMetaData metaData = stateManager.getMetaData();
        EntityFacade entityFacade = new EntityFacade(metaData);
        for (Map.Entry<String, EntityFacade.ColumnMeta<?>> entry : entityFacade.getColumnMeta().entrySet()) {
            mutator.addInsertion((Object)this.mappingUtils.getKeyBytes(idObj), entityFacade.getColumnFamilyName(), (HColumn)new HColumnImpl((Object)entry.getKey(), stateManager.fetch(entry.getValue().fieldId), this.keyspace.createClock(), (Serializer)StringSerializer.get(), entry.getValue().serializer));
        }
        return mutator;
    }

    public Mutator removeObject(Mutator mutator, OpenJPAStateManager stateManager, Object idObj) {
        if (mutator == null) {
            mutator = new MutatorImpl(this.keyspace, (Serializer)BytesArraySerializer.get());
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding mutation (deletion) for class {}", (Object)stateManager.getManagedInstance().getClass().getName());
        }
        ClassMetaData metaData = stateManager.getMetaData();
        EntityFacade entityFacade = new EntityFacade(metaData);
        mutator.addDeletion((Object)this.mappingUtils.getKeyBytes(idObj), entityFacade.getColumnFamilyName(), null, (Serializer)StringSerializer.get());
        return mutator;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }
}

