/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.openjpa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hom.openjpa.CassandraStore;
import me.prettyprint.hom.openjpa.CassandraStoreConfiguration;
import org.apache.openjpa.abstractstore.AbstractStoreManager;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoreManager
extends AbstractStoreManager {
    private static Logger log = LoggerFactory.getLogger(CassandraStoreManager.class);
    private CassandraStore cassandraStore;

    public ResultObjectProvider executeExtent(ClassMetaData cMetaData, boolean useSubClasses, FetchConfiguration fetchConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug("in executeExtent with ClassMetaData {}: useSubClasses: {} and fetchConfiguration: {}", new Object[]{cMetaData, useSubClasses, fetchConfiguration});
        }
        return null;
    }

    protected Collection flush(Collection pNew, Collection pNewUpdated, Collection pNewFlushedDeleted, Collection pDirty, Collection pDeleted) {
        this.cassandraStore.open();
        OpenJPAConfiguration conf = this.ctx.getConfiguration();
        Mutator mutator = null;
        for (OpenJPAStateManager sm : pNew) {
            Object oid = sm.getObjectId();
            mutator = this.cassandraStore.storeObject(mutator, sm, oid);
        }
        if (!pDeleted.isEmpty() || !pNewFlushedDeleted.isEmpty()) {
            ArrayList deletes = new ArrayList(pDeleted.size() + pNewFlushedDeleted.size());
            deletes.addAll(pDeleted);
            deletes.addAll(pNewFlushedDeleted);
            for (OpenJPAStateManager sm : deletes) {
                Object oid = sm.getObjectId();
                mutator = this.cassandraStore.removeObject(mutator, sm, oid);
            }
        }
        mutator.execute();
        return null;
    }

    public boolean initialize(OpenJPAStateManager stateManager, PCState pcState, FetchConfiguration fetchConfiguration, Object obj) {
        log.debug("In initialize operation...");
        this.cassandraStore.open();
        stateManager.initialize(stateManager.getMetaData().getDescribedType(), pcState);
        this.cassandraStore.getObject(stateManager, stateManager.getId());
        return true;
    }

    public boolean load(OpenJPAStateManager stateManager, BitSet arg1, FetchConfiguration arg2, int arg3, Object arg4) {
        log.debug("In load operation...");
        this.cassandraStore.getObject(stateManager, stateManager.getId());
        return false;
    }

    public boolean exists(OpenJPAStateManager arg0, Object arg1) {
        log.debug("In CSM.exists()");
        return false;
    }

    public boolean isCached(List<Object> arg0, BitSet arg1) {
        log.debug("In CSM.isCached()");
        return false;
    }

    public int compareVersion(OpenJPAStateManager state, Object v1, Object v2) {
        log.debug("in CSM.compareVersion");
        return super.compareVersion(state, v1, v2);
    }

    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        log.debug("in CSM.syncVersion");
        return super.syncVersion(sm, edata);
    }

    protected void open() {
        OpenJPAConfiguration conf = this.ctx.getConfiguration();
        this.cassandraStore = new CassandraStore((CassandraStoreConfiguration)conf);
        log.debug("in CSM.open()");
    }

    protected Collection getUnsupportedOptions() {
        Collection c = super.getUnsupportedOptions();
        c.add("openjpa.option.EmbeddedRelation");
        c.add("openjpa.option.EmbeddedCollectionRelation");
        c.add("openjpa.option.EmbeddedMapRelation");
        return c;
    }

    protected OpenJPAConfiguration newConfiguration() {
        CassandraStoreConfiguration conf = new CassandraStoreConfiguration();
        if (log.isDebugEnabled()) {
            log.debug("In newConfiguration with conf: {}", (Object)conf.toProperties(true));
        }
        return conf;
    }
}

