/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.openjpa;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Table;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hom.openjpa.MappingUtils;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFacade
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(EntityFacade.class);
    private static final long serialVersionUID = 4777260639119126462L;
    private final String columnFamilyName;
    private final Class<?> clazz;
    private final Serializer<?> keySerializer;
    private final Map<String, ColumnMeta<?>> columnMetas;

    public EntityFacade(ClassMetaData classMetaData) {
        this.clazz = classMetaData.getDescribedType();
        this.columnFamilyName = this.clazz.getAnnotation(Table.class) != null ? this.clazz.getAnnotation(Table.class).name() : this.clazz.getSimpleName();
        this.keySerializer = MappingUtils.getSerializer(classMetaData.getPrimaryKeyFields()[0].getObjectIdFieldTypeCode());
        this.columnMetas = new HashMap();
        FieldMetaData[] fmds = classMetaData.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getManagement() == 0 || fmds[i].isPrimaryKey()) continue;
            if (log.isDebugEnabled()) {
                log.debug("field name {} typeCode {}", (Object)fmds[i].getName(), (Object)fmds[i].getTypeCode());
            }
            this.columnMetas.put(fmds[i].getName(), new ColumnMeta(fmds[i].getIndex(), MappingUtils.getSerializer(fmds[i].getTypeCode())));
        }
    }

    public String[] getColumnNames() {
        return this.columnMetas.keySet().toArray(new String[0]);
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Serializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public int getFieldId(String columnName) {
        return this.columnMetas.get((Object)columnName).fieldId;
    }

    public Serializer<?> getSerializer(String columnName) {
        return this.columnMetas.get((Object)columnName).serializer;
    }

    public Map<String, ColumnMeta<?>> getColumnMeta() {
        return this.columnMetas;
    }

    public String toString() {
        return String.format("EntityFacade[class: %s, columnFamily: %s, columnNames: %s]", this.clazz.getName(), this.columnFamilyName, Arrays.toString(this.getColumnNames()));
    }

    class ColumnMeta<V> {
        int fieldId;
        Serializer<V> serializer;

        ColumnMeta(int fieldId, Serializer<V> serializer) {
            this.fieldId = fieldId;
            this.serializer = serializer;
        }
    }
}

