/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.openjpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.thrift.ThriftSliceQuery;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.ObjectSerializer;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hom.openjpa.EntityFacade;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.OpenJPAId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUtils {
    private static final Logger log = LoggerFactory.getLogger(MappingUtils.class);
    private static final Map<Integer, Serializer<?>> typeSerializerMap = new HashMap();

    public static Serializer<?> getSerializer(int javaType) {
        return typeSerializerMap.get(javaType) != null ? typeSerializerMap.get(javaType) : ObjectSerializer.get();
    }

    public SliceQuery<byte[], String, byte[]> buildSliceQuery(Object idObj, EntityFacade entityFacade, Keyspace keyspace) {
        ThriftSliceQuery query = new ThriftSliceQuery(keyspace, (Serializer)BytesArraySerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        query.setColumnNames((Object[])entityFacade.getColumnNames());
        query.setKey((Object)this.getKeyBytes(idObj));
        query.setColumnFamily(entityFacade.getColumnFamilyName());
        return query;
    }

    public byte[] getKeyBytes(Object idObj) {
        Serializer serializer = this.getSerializer(idObj);
        if (idObj instanceof OpenJPAId) {
            return serializer.toBytes(((OpenJPAId)idObj).getIdObject());
        }
        return serializer.toBytes(idObj);
    }

    public Serializer getSerializer(Object idObj) {
        Serializer serializer = idObj instanceof OpenJPAId ? SerializerTypeInferer.getSerializer((Object)((OpenJPAId)idObj).getIdObject()) : SerializerTypeInferer.getSerializer((Object)idObj);
        return serializer;
    }

    List<String> buildColumnList(ClassMetaData metaData) {
        FieldMetaData[] fmds = metaData.getFields();
        ArrayList<String> cols = new ArrayList<String>(fmds.length);
        for (int i = 0; i < fmds.length; ++i) {
            FieldMetaData cfr_ignored_0 = fmds[i];
            if (fmds[i].getManagement() != 3 || fmds[i].isPrimaryKey()) continue;
            log.debug("fmd.name: {}", (Object)fmds[i].getName());
            cols.add(fmds[i].getName());
        }
        return cols;
    }

    Map<String, Serializer> buildColumnSerializerMap(ClassMetaData metaData) {
        HashMap<String, Serializer> serMap = new HashMap<String, Serializer>();
        FieldMetaData[] fmds = metaData.getFields();
        block10: for (int i = 0; i < fmds.length; ++i) {
            FieldMetaData cfr_ignored_0 = fmds[i];
            if (fmds[i].getManagement() != 3 || fmds[i].isPrimaryKey()) continue;
            switch (fmds[i].getTypeCode()) {
                case 9: {
                    serMap.put(fmds[i].getName(), (Serializer)StringSerializer.get());
                    continue block10;
                }
                case 5: {
                    serMap.put(fmds[i].getName(), (Serializer)IntegerSerializer.get());
                    continue block10;
                }
                case 21: {
                    serMap.put(fmds[i].getName(), (Serializer)IntegerSerializer.get());
                    continue block10;
                }
                case 14: {
                    serMap.put(fmds[i].getName(), (Serializer)DateSerializer.get());
                    continue block10;
                }
                case 6: {
                    serMap.put(fmds[i].getName(), (Serializer)LongSerializer.get());
                    continue block10;
                }
                case 22: {
                    serMap.put(fmds[i].getName(), (Serializer)LongSerializer.get());
                    continue block10;
                }
                case 3: {
                    serMap.put(fmds[i].getName(), (Serializer)DoubleSerializer.get());
                    continue block10;
                }
                case 19: {
                    serMap.put(fmds[i].getName(), (Serializer)DoubleSerializer.get());
                    continue block10;
                }
                default: {
                    serMap.put(fmds[i].getName(), (Serializer)ObjectSerializer.get());
                }
            }
        }
        return serMap;
    }

    public Mutator addMutation(Mutator mutator, Object idObj, OpenJPAStateManager stateManager, Keyspace keyspace) {
        ClassMetaData metaData = stateManager.getMetaData();
        Map<String, Serializer> serMap = this.buildColumnSerializerMap(metaData);
        for (Map.Entry<String, Serializer> entry : serMap.entrySet()) {
            mutator.addInsertion((Object)this.getKeyBytes(idObj), "TestBeanColumnFamily", HFactory.createColumn((Object)entry.getKey(), (Object)stateManager.fetch(metaData.getField(entry.getKey()).getIndex()), (Serializer)StringSerializer.get(), (Serializer)entry.getValue()));
        }
        return mutator;
    }

    static {
        typeSerializerMap.put(9, (Serializer<?>)StringSerializer.get());
        typeSerializerMap.put(5, (Serializer<?>)IntegerSerializer.get());
        typeSerializerMap.put(21, (Serializer<?>)IntegerSerializer.get());
        typeSerializerMap.put(14, (Serializer<?>)DateSerializer.get());
        typeSerializerMap.put(6, (Serializer<?>)LongSerializer.get());
        typeSerializerMap.put(22, (Serializer<?>)LongSerializer.get());
        typeSerializerMap.put(3, (Serializer<?>)DoubleSerializer.get());
        typeSerializerMap.put(19, (Serializer<?>)DoubleSerializer.get());
    }
}

